<!DOCTYPE html>
<html lang="en" dir="rtl">
    <head>
        
    <style type="text/css">
        .swal-icon--error {
            border-color: #f27474;
            -webkit-animation: animateErrorIcon .5s;
            animation: animateErrorIcon .5s
        }

        .swal-icon--error__x-mark {
            position: relative;
            display: block;
            -webkit-animation: animateXMark .5s;
            animation: animateXMark .5s
        }

        .swal-icon--error__line {
            position: absolute;
            height: 5px;
            width: 47px;
            background-color: #f27474;
            display: block;
            top: 37px;
            border-radius: 2px
        }

        .swal-icon--error__line--left {
            -webkit-transform: rotate(45deg);
            transform: rotate(45deg);
            left: 17px
        }

        .swal-icon--error__line--right {
            -webkit-transform: rotate(-45deg);
            transform: rotate(-45deg);
            right: 16px
        }

        @-webkit-keyframes animateErrorIcon {
            0% {
                -webkit-transform: rotateX(100deg);
                transform: rotateX(100deg);
                opacity: 0
            }

            to {
                -webkit-transform: rotateX(0deg);
                transform: rotateX(0deg);
                opacity: 1
            }
        }

        @keyframes animateErrorIcon {
            0% {
                -webkit-transform: rotateX(100deg);
                transform: rotateX(100deg);
                opacity: 0
            }

            to {
                -webkit-transform: rotateX(0deg);
                transform: rotateX(0deg);
                opacity: 1
            }
        }

        @-webkit-keyframes animateXMark {
            0% {
                -webkit-transform: scale(.4);
                transform: scale(.4);
                margin-top: 26px;
                opacity: 0
            }

            50% {
                -webkit-transform: scale(.4);
                transform: scale(.4);
                margin-top: 26px;
                opacity: 0
            }

            80% {
                -webkit-transform: scale(1.15);
                transform: scale(1.15);
                margin-top: -6px
            }

            to {
                -webkit-transform: scale(1);
                transform: scale(1);
                margin-top: 0;
                opacity: 1
            }
        }

        @keyframes animateXMark {
            0% {
                -webkit-transform: scale(.4);
                transform: scale(.4);
                margin-top: 26px;
                opacity: 0
            }

            50% {
                -webkit-transform: scale(.4);
                transform: scale(.4);
                margin-top: 26px;
                opacity: 0
            }

            80% {
                -webkit-transform: scale(1.15);
                transform: scale(1.15);
                margin-top: -6px
            }

            to {
                -webkit-transform: scale(1);
                transform: scale(1);
                margin-top: 0;
                opacity: 1
            }
        }

        .swal-icon--warning {
            border-color: #f8bb86;
            -webkit-animation: pulseWarning .75s infinite alternate;
            animation: pulseWarning .75s infinite alternate
        }

        .swal-icon--warning__body {
            width: 5px;
            height: 47px;
            top: 10px;
            border-radius: 2px;
            margin-left: -2px
        }

        .swal-icon--warning__body,
        .swal-icon--warning__dot {
            position: absolute;
            left: 50%;
            background-color: #f8bb86
        }

        .swal-icon--warning__dot {
            width: 7px;
            height: 7px;
            border-radius: 50%;
            margin-left: -4px;
            bottom: -11px
        }

        @-webkit-keyframes pulseWarning {
            0% {
                border-color: #f8d486
            }

            to {
                border-color: #f8bb86
            }
        }

        @keyframes pulseWarning {
            0% {
                border-color: #f8d486
            }

            to {
                border-color: #f8bb86
            }
        }

        .swal-icon--success {
            border-color: #a5dc86
        }

        .swal-icon--success:after,
        .swal-icon--success:before {
            content: "";
            border-radius: 50%;
            position: absolute;
            width: 60px;
            height: 120px;
            background: #fff;
            -webkit-transform: rotate(45deg);
            transform: rotate(45deg)
        }

        .swal-icon--success:before {
            border-radius: 120px 0 0 120px;
            top: -7px;
            left: -33px;
            -webkit-transform: rotate(-45deg);
            transform: rotate(-45deg);
            -webkit-transform-origin: 60px 60px;
            transform-origin: 60px 60px
        }

        .swal-icon--success:after {
            border-radius: 0 120px 120px 0;
            top: -11px;
            left: 30px;
            -webkit-transform: rotate(-45deg);
            transform: rotate(-45deg);
            -webkit-transform-origin: 0 60px;
            transform-origin: 0 60px;
            -webkit-animation: rotatePlaceholder 4.25s ease-in;
            animation: rotatePlaceholder 4.25s ease-in
        }

        .swal-icon--success__ring {
            width: 80px;
            height: 80px;
            border: 4px solid hsla(98, 55%, 69%, .2);
            border-radius: 50%;
            box-sizing: content-box;
            position: absolute;
            left: -4px;
            top: -4px;
            z-index: 2
        }

        .swal-icon--success__hide-corners {
            width: 5px;
            height: 90px;
            background-color: #fff;
            padding: 1px;
            position: absolute;
            left: 28px;
            top: 8px;
            z-index: 1;
            -webkit-transform: rotate(-45deg);
            transform: rotate(-45deg)
        }

        .swal-icon--success__line {
            height: 5px;
            background-color: #a5dc86;
            display: block;
            border-radius: 2px;
            position: absolute;
            z-index: 2
        }

        .swal-icon--success__line--tip {
            width: 25px;
            left: 14px;
            top: 46px;
            -webkit-transform: rotate(45deg);
            transform: rotate(45deg);
            -webkit-animation: animateSuccessTip .75s;
            animation: animateSuccessTip .75s
        }

        .swal-icon--success__line--long {
            width: 47px;
            right: 8px;
            top: 38px;
            -webkit-transform: rotate(-45deg);
            transform: rotate(-45deg);
            -webkit-animation: animateSuccessLong .75s;
            animation: animateSuccessLong .75s
        }

        @-webkit-keyframes rotatePlaceholder {
            0% {
                -webkit-transform: rotate(-45deg);
                transform: rotate(-45deg)
            }

            5% {
                -webkit-transform: rotate(-45deg);
                transform: rotate(-45deg)
            }

            12% {
                -webkit-transform: rotate(-405deg);
                transform: rotate(-405deg)
            }

            to {
                -webkit-transform: rotate(-405deg);
                transform: rotate(-405deg)
            }
        }

        @keyframes rotatePlaceholder {
            0% {
                -webkit-transform: rotate(-45deg);
                transform: rotate(-45deg)
            }

            5% {
                -webkit-transform: rotate(-45deg);
                transform: rotate(-45deg)
            }

            12% {
                -webkit-transform: rotate(-405deg);
                transform: rotate(-405deg)
            }

            to {
                -webkit-transform: rotate(-405deg);
                transform: rotate(-405deg)
            }
        }

        @-webkit-keyframes animateSuccessTip {
            0% {
                width: 0;
                left: 1px;
                top: 19px
            }

            54% {
                width: 0;
                left: 1px;
                top: 19px
            }

            70% {
                width: 50px;
                left: -8px;
                top: 37px
            }

            84% {
                width: 17px;
                left: 21px;
                top: 48px
            }

            to {
                width: 25px;
                left: 14px;
                top: 45px
            }
        }

        @keyframes animateSuccessTip {
            0% {
                width: 0;
                left: 1px;
                top: 19px
            }

            54% {
                width: 0;
                left: 1px;
                top: 19px
            }

            70% {
                width: 50px;
                left: -8px;
                top: 37px
            }

            84% {
                width: 17px;
                left: 21px;
                top: 48px
            }

            to {
                width: 25px;
                left: 14px;
                top: 45px
            }
        }

        @-webkit-keyframes animateSuccessLong {
            0% {
                width: 0;
                right: 46px;
                top: 54px
            }

            65% {
                width: 0;
                right: 46px;
                top: 54px
            }

            84% {
                width: 55px;
                right: 0;
                top: 35px
            }

            to {
                width: 47px;
                right: 8px;
                top: 38px
            }
        }

        @keyframes animateSuccessLong {
            0% {
                width: 0;
                right: 46px;
                top: 54px
            }

            65% {
                width: 0;
                right: 46px;
                top: 54px
            }

            84% {
                width: 55px;
                right: 0;
                top: 35px
            }

            to {
                width: 47px;
                right: 8px;
                top: 38px
            }
        }

        .swal-icon--info {
            border-color: #c9dae1
        }

        .swal-icon--info:before {
            width: 5px;
            height: 29px;
            bottom: 17px;
            border-radius: 2px;
            margin-left: -2px
        }

        .swal-icon--info:after,
        .swal-icon--info:before {
            content: "";
            position: absolute;
            left: 50%;
            background-color: #c9dae1
        }

        .swal-icon--info:after {
            width: 7px;
            height: 7px;
            border-radius: 50%;
            margin-left: -3px;
            top: 19px
        }

        .swal-icon {
            width: 80px;
            height: 80px;
            border-width: 4px;
            border-style: solid;
            border-radius: 50%;
            padding: 0;
            position: relative;
            box-sizing: content-box;
            margin: 20px auto
        }

        .swal-icon:first-child {
            margin-top: 32px
        }

        .swal-icon--custom {
            width: auto;
            height: auto;
            max-width: 100%;
            border: none;
            border-radius: 0
        }

        .swal-icon img {
            max-width: 100%;
            max-height: 100%
        }

        .swal-title {
            color: rgba(0, 0, 0, .65);
            font-weight: 600;
            text-transform: none;
            position: relative;
            display: block;
            padding: 13px 16px;
            font-size: 27px;
            line-height: normal;
            text-align: center;
            margin-bottom: 0
        }

        .swal-title:first-child {
            margin-top: 26px
        }

        .swal-title:not(:first-child) {
            padding-bottom: 0
        }

        .swal-title:not(:last-child) {
            margin-bottom: 13px
        }

        .swal-text {
            font-size: 16px;
            position: relative;
            float: none;
            line-height: normal;
            vertical-align: top;
            text-align: left;
            display: inline-block;
            margin: 0;
            padding: 0 10px;
            font-weight: 400;
            color: rgba(0, 0, 0, .64);
            max-width: calc(100% - 20px);
            overflow-wrap: break-word;
            box-sizing: border-box
        }

        .swal-text:first-child {
            margin-top: 45px
        }

        .swal-text:last-child {
            margin-bottom: 45px
        }

        .swal-footer {
            text-align: right;
            padding-top: 13px;
            margin-top: 13px;
            padding: 13px 16px;
            border-radius: inherit;
            border-top-left-radius: 0;
            border-top-right-radius: 0
        }

        .swal-button-container {
            margin: 5px;
            display: inline-block;
            position: relative
        }

        .swal-button {
            background-color: #7cd1f9;
            color: #fff;
            border: none;
            box-shadow: none;
            border-radius: 5px;
            font-weight: 600;
            font-size: 14px;
            padding: 10px 24px;
            margin: 0;
            cursor: pointer
        }

        .swal-button:not([disabled]):hover {
            background-color: #78cbf2
        }

        .swal-button:active {
            background-color: #70bce0
        }

        .swal-button:focus {
            outline: none;
            box-shadow: 0 0 0 1px #fff, 0 0 0 3px rgba(43, 114, 165, .29)
        }

        .swal-button[disabled] {
            opacity: .5;
            cursor: default
        }

        .swal-button::-moz-focus-inner {
            border: 0
        }

        .swal-button--cancel {
            color: #555;
            background-color: #efefef
        }

        .swal-button--cancel:not([disabled]):hover {
            background-color: #e8e8e8
        }

        .swal-button--cancel:active {
            background-color: #d7d7d7
        }

        .swal-button--cancel:focus {
            box-shadow: 0 0 0 1px #fff, 0 0 0 3px rgba(116, 136, 150, .29)
        }

        .swal-button--danger {
            background-color: #e64942
        }

        .swal-button--danger:not([disabled]):hover {
            background-color: #df4740
        }

        .swal-button--danger:active {
            background-color: #cf423b
        }

        .swal-button--danger:focus {
            box-shadow: 0 0 0 1px #fff, 0 0 0 3px rgba(165, 43, 43, .29)
        }

        .swal-content {
            padding: 0 20px;
            margin-top: 20px;
            font-size: medium
        }

        .swal-content:last-child {
            margin-bottom: 20px
        }

        .swal-content__input,
        .swal-content__textarea {
            -webkit-appearance: none;
            background-color: #fff;
            border: none;
            font-size: 14px;
            display: block;
            box-sizing: border-box;
            width: 100%;
            border: 1px solid rgba(0, 0, 0, .14);
            padding: 10px 13px;
            border-radius: 2px;
            transition: border-color .2s
        }

        .swal-content__input:focus,
        .swal-content__textarea:focus {
            outline: none;
            border-color: #6db8ff
        }

        .swal-content__textarea {
            resize: vertical
        }

        .swal-button--loading {
            color: transparent
        }

        .swal-button--loading~.swal-button__loader {
            opacity: 1
        }

        .swal-button__loader {
            position: absolute;
            height: auto;
            width: 43px;
            z-index: 2;
            left: 50%;
            top: 50%;
            -webkit-transform: translateX(-50%) translateY(-50%);
            transform: translateX(-50%) translateY(-50%);
            text-align: center;
            pointer-events: none;
            opacity: 0
        }

        .swal-button__loader div {
            display: inline-block;
            float: none;
            vertical-align: baseline;
            width: 9px;
            height: 9px;
            padding: 0;
            border: none;
            margin: 2px;
            opacity: .4;
            border-radius: 7px;
            background-color: hsla(0, 0%, 100%, .9);
            transition: background .2s;
            -webkit-animation: swal-loading-anim 1s infinite;
            animation: swal-loading-anim 1s infinite
        }

        .swal-button__loader div:nth-child(3n+2) {
            -webkit-animation-delay: .15s;
            animation-delay: .15s
        }

        .swal-button__loader div:nth-child(3n+3) {
            -webkit-animation-delay: .3s;
            animation-delay: .3s
        }

        @-webkit-keyframes swal-loading-anim {
            0% {
                opacity: .4
            }

            20% {
                opacity: .4
            }

            50% {
                opacity: 1
            }

            to {
                opacity: .4
            }
        }

        @keyframes swal-loading-anim {
            0% {
                opacity: .4
            }

            20% {
                opacity: .4
            }

            50% {
                opacity: 1
            }

            to {
                opacity: .4
            }
        }

        .swal-overlay {
            position: fixed;
            top: 0;
            bottom: 0;
            left: 0;
            right: 0;
            text-align: center;
            font-size: 0;
            overflow-y: auto;
            background-color: rgba(0, 0, 0, .4);
            z-index: 10000;
            pointer-events: none;
            opacity: 0;
            transition: opacity .3s
        }

        .swal-overlay:before {
            content: " ";
            display: inline-block;
            vertical-align: middle;
            height: 100%
        }

        .swal-overlay--show-modal {
            opacity: 1;
            pointer-events: auto
        }

        .swal-overlay--show-modal .swal-modal {
            opacity: 1;
            pointer-events: auto;
            box-sizing: border-box;
            -webkit-animation: showSweetAlert .3s;
            animation: showSweetAlert .3s;
            will-change: transform
        }

        .swal-modal {
            width: 478px;
            opacity: 0;
            pointer-events: none;
            background-color: #fff;
            text-align: center;
            border-radius: 5px;
            position: static;
            margin: 20px auto;
            display: inline-block;
            vertical-align: middle;
            -webkit-transform: scale(1);
            transform: scale(1);
            -webkit-transform-origin: 50% 50%;
            transform-origin: 50% 50%;
            z-index: 10001;
            transition: opacity .2s, -webkit-transform .3s;
            transition: transform .3s, opacity .2s;
            transition: transform .3s, opacity .2s, -webkit-transform .3s
        }

        @media (max-width:500px) {
            .swal-modal {
                width: calc(100% - 20px)
            }
        }

        @-webkit-keyframes showSweetAlert {
            0% {
                -webkit-transform: scale(1);
                transform: scale(1)
            }

            1% {
                -webkit-transform: scale(.5);
                transform: scale(.5)
            }

            45% {
                -webkit-transform: scale(1.05);
                transform: scale(1.05)
            }

            80% {
                -webkit-transform: scale(.95);
                transform: scale(.95)
            }

            to {
                -webkit-transform: scale(1);
                transform: scale(1)
            }
        }

        @keyframes showSweetAlert {
            0% {
                -webkit-transform: scale(1);
                transform: scale(1)
            }

            1% {
                -webkit-transform: scale(.5);
                transform: scale(.5)
            }

            45% {
                -webkit-transform: scale(1.05);
                transform: scale(1.05)
            }

            80% {
                -webkit-transform: scale(.95);
                transform: scale(.95)
            }

            to {
                -webkit-transform: scale(1);
                transform: scale(1)
            }
        }
    </style>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <meta name="description" content="دليلك الأول للعقارات فى القاهرة الجديدة و الرحاب و مدينتى و شقق للبيع و الايجار و فلل للبيع و الايجار فى الرحاب و مدينتى و القاهرة الجديدة.">
        <meta name="keywords" content="شقق للبيع فى مدينتى, شقق للبيع فى الرحاب, فلل للبيع فى مدينتى, فلل للايجار فى الرحاب, شقق للبيع فى القاهرة الجديدة, فلل للبيع فى القاهرة الجديدة, شقق للبيع فى التجمع الخامس, شقق للايجار فى التجمع الخامس" />
        <meta name="rights" content="جميع الحقوق محفوظة لالباصات" />
        <meta name='audience' content='all' />
        <meta name="distribution" content="global" />
        <meta name="robots" content="all" />
        <meta name='rating' content='general' />

        <meta name="expires" content="never" />  
        
        <meta name="author" content="Coderthemes">
        <meta name="csrf-token" content="{{csrf_token()}}">
        <meta name="generator" content="loc.sa" />
       
        
        
        
        {{-- <link rel="apple-touch-icon" sizes="57x57" href="{{ asset('/adminto/assets/images/favicon/apple-icon-57x57.png')}}"> --}}
        <link rel="icon" type="image/jpg" href="/front/images/logova.jpg"/>
<link rel="apple-touch-icon" sizes="60x60" href="{{ asset('/adminto/assets/images/favicon/apple-icon-60x60.png')}}">
<link rel="apple-touch-icon" sizes="72x72" href="{{ asset('/adminto/assets/images/favicon/apple-icon-72x72.png')}}">
<link rel="apple-touch-icon" sizes="76x76" href="{{ asset('/adminto/assets/images/favicon/apple-icon-76x76.png')}}">
<link rel="apple-touch-icon" sizes="114x114" href="{{ asset('/adminto/assets/images/favicon/apple-icon-114x114.png')}}">
<link rel="apple-touch-icon" sizes="120x120" href="{{ asset('/adminto/assets/images/favicon/apple-icon-120x120.png')}}">
<link rel="apple-touch-icon" sizes="144x144" href="{{ asset('/adminto/assets/images/favicon/apple-icon-144x144.png')}}">
<link rel="apple-touch-icon" sizes="152x152" href="{{ asset('/adminto/assets/images/favicon/apple-icon-152x152.png')}}">
<link rel="apple-touch-icon" sizes="180x180" href="{{ asset('/adminto/assets/images/favicon/apple-icon-180x180.png')}}">
<link rel="icon" type="image/png" sizes="192x192"  href="{{ asset('/adminto/assets/images/favicon/android-icon-192x192.png')}}">
<link rel="icon" type="image/png" sizes="32x32" href="{{ asset('/adminto/assets/images/favicon/favicon-32x32.png')}}">
<link rel="icon" type="image/png" sizes="96x96" href="{{ asset('/adminto/assets/images/favicon/favicon-96x96.png')}}">
<link rel="icon" type="image/png" sizes="16x16" href="{{ asset('/adminto/assets/images/favicon/favicon-16x16.png')}}">
<link rel="manifest" href="/manifest.json">
<meta name="msapplication-TileColor" content="#ffffff">
<meta name="msapplication-TileImage" content="{{ asset('/adminto/assets/images/favicon/ms-icon-144x144.png')}}">
<meta name="theme-color" content="#ffffff">



        <title>الاومير | {{(isset($title))? $title : ''}}  </title>
        <link href="https://fonts.googleapis.com/css?family=Cairo:400,600,700,900|Tajawal:400,500,700&amp;subset=arabic" rel="stylesheet">
        <!-- Modal -->
        <link href="{{ asset('/adminto/assets/plugins/custombox/dist/custombox.min.css')}}" rel="stylesheet">
        <link href="{{ asset('/adminto/assets/plugins/toastr/toastr.min.css')}}" rel="stylesheet" type="text/css" />

        <link href="{{ asset('/adminto/assets/plugins/multiselect/css/multi-select.css')}}"  rel="stylesheet" type="text/css" />
        <link href="{{ asset('/adminto/assets/plugins/select2/dist/css/select2.css')}}" rel="stylesheet" type="text/css">
        <link href="{{ asset('/adminto/assets/plugins/select2/dist/css/select2-bootstrap.css')}}" rel="stylesheet" type="text/css">

        <link href="/adminto/assets/plugins/switchery/switchery.min.css" rel="stylesheet" />

        <link href="{{ asset('/adminto/assets/css/bootstrap-rtl.min.css')}}" rel="stylesheet" type="text/css" />
        <link href="{{ asset('/adminto/assets/css/core.css')}}" rel="stylesheet" type="text/css" />
        <link href="{{ asset('/adminto/assets/css/components.css')}}" rel="stylesheet" type="text/css" />
        <link href="{{ asset('/adminto/assets/css/icons.css')}}" rel="stylesheet" type="text/css" />
        <link href="{{ asset('/adminto/assets/css/pages.css')}}" rel="stylesheet" type="text/css" />
        <link href="{{ asset('/adminto/assets/css/menu.css')}}" rel="stylesheet" type="text/css" />
        <link href="{{ asset('/adminto/assets/css/responsive.css')}}" rel="stylesheet" type="text/css" />
        <link href="{{ asset('/adminto/assets/plugins/timepicker/bootstrap-timepicker.min.css')}}" rel="stylesheet">

        <!-- HTML5 Shiv and Respond.js IE8 support of HTML5 elements and media queries -->
        <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
        <!--[if lt IE 9]>
        <script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
        <script src="https://oss.maxcdn.com/libs/respond.js/1.3.0/respond.min.js"></script>
        <![endif]-->
        @yield('style')
        <script src="{{ asset('/adminto/assets/js/modernizr.min.js')}}"></script>
        <style type="text/css">
            /*@media (min-width: 992px){
                #topnav .navigation-menu>li>a {
                    padding-left: 0;
                    }
                }*/
                
                #load{
                    width:100%;
                    height:100%;
                    position:fixed;
                    z-index:9999;
                    background:url("{{url('/preloader.gif')}}") no-repeat center center rgba(0,0,0,0.25)
                }
                .pop_image_item{
                    width: 300px;
                    height: 300px;
                    border-radius: 15px;
                    border: 2px solid #435966;
                    }
        </style>


<link rel="stylesheet" href="/myCss.css">
    </head>


    <body>
        <div id="load"></div>

        <!-- Navigation Bar-->
        <header id="topnav">
            <div class="topbar-main">
                <div class="container">

                    <!-- LOGO -->
                    <div class="topbar-left">
                        <a href="{{url('/dashboard')}}" class="logo">
                            <img src="{{asset('logo.png')}}" style="height: 52px;width: 235px;" />
                        </a>
                    </div>
                    <!-- End Logo container-->


                    <div class="menu-extras">

                        <ul class="nav navbar-nav navbar-right pull-right">
                            <li>
                                <form role="search" class="navbar-left app-search pull-left hidden-xs">
                                     <input type="text" placeholder="Search..." class="form-control">
                                     <a href=""><i class="fa fa-search"></i></a>
                                </form>
                            </li>
                            <li>
                            @php
                            if(auth()->user()->role == 'admin')
                            {
                                $user = \App\Models\Admin::where('role', 'admin')->first();
                            }else{
                                $user = auth()->user();
                            }
                            @endphp
                                <!-- Notification -->
                                <div class="notification-box">
                                    <ul class="list-inline m-b-0">
                                        <li>
                                            <a href="javascript:void(0);" class="right-bar-toggle">
                                                <i class="zmdi zmdi-notifications-none"></i>
                                            </a>
                                            <div id="notify-sign" class="noti-dot {{($user->unreadnotifications->count() > 0)? '' : 'hidden'}}">
                                                <span class="dot"></span>
                                                <span class="pulse"></span>
                                            </div>
                                        </li>
                                    </ul>
                                </div>
                                <!-- End Notification bar -->
                            </li>

                            @if(auth()->guard('admin')->check())
                            <li class="dropdown user-box {!! (CheckPermission('settings_show'))? '' : 'hidden'  !!}" >
                                <a href="{{url('/dashboard/settings/site')}}" class=" waves-effect waves-light profile " >
                                    <span><i class="fa fa-cog"></i></span>
                                </a>
                            </li>
                            @endif

                            <li class="dropdown user-box">
                                <a href="" class="dropdown-toggle waves-effect waves-light profile " data-toggle="dropdown" aria-expanded="true">
                                    <img src="{{(auth()->user()->image)?getImage(auth()->user()->image):asset('/adminto/assets/images/users/avatar-1.jpg')}}" alt="user-img" class="img-circle user-img">
                                    <div class="user-status away"><i class="zmdi zmdi-dot-circle"></i></div>
                                </a>

                                <ul class="dropdown-menu">
                                    <li><a href="{{url('/dashboard/settings/admins-edit/'.auth()->id())}}"><i class="ti-user m-r-5"></i> الملف الشخصي</a></li>
                                    <li><a href="{{ url('/dashboard/branches') }}"><i class="ti-settings m-r-5"></i>ادارة الفروع</a></li>
                                    <li><a href="{{url('/dashboard/settings/site')}}"><i class="ti-settings m-r-5"></i> الأعدادات</a></li>
                                    <li>  <a href="{{ route('logout') }}"
                                                 onclick="event.preventDefault();
                                                     document.getElementById('logout-form').submit();">
                                                <span class="ti-power-off m-r-5"></span> تسجيل الخروج
                                            </a>
                                            <form id="logout-form" action="{{ route('logout') }}" method="POST" style="display: none;">
                                                {{ csrf_field() }}
                                                <input type="hidden" name="dashboard" value="1">
                                            </form>
                                        </li>
                                </ul>
                            </li>
                        </ul>
                        
                        <div class="menu-item">
                            <!-- Mobile menu toggle-->
                            <a class="navbar-toggle">
                                <div class="lines">
                                    <span></span>
                                    <span></span>
                                    <span></span>
                                </div>
                            </a>
                            <!-- End mobile menu toggle-->
                        </div>
                    </div>

                </div>
            </div>

            <div class="navbar-custom">
                <div class="container">
                    <div id="navigation">
                        @include('admin.layout.nav')
                    </div>
                </div>
            </div>
        </header>
        <!-- End Navigation Bar-->


        <div class="wrapper">
            <div class="container">
                @if ($errors->any())
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif


                @yield('content')


                <!-- Footer -->
                <footer class="footer">
                    <div class="container">
                        <div class="row">
                            <div class="col-xs-12 text-center">
                                كل الحقوق محفوظة لدى   2019 تصميم وبرمجة
                                <a href="http://loc.sa" target="_blank">
                                    مدار الريادة لتقنية المعلومات
                                </a>
                            </div>
                        </div>
                    </div>
                </footer>
                <!-- End Footer -->

            </div>
            <!-- end container -->



            <!-- Right Sidebar -->
            <div class="side-bar right-bar">
                <a href="javascript:void(0);" class="right-bar-toggle">
                    <i class="zmdi zmdi-close-circle-o"></i>
                </a>
                <h4 class="">التنبيهات</h4>
                <div class="notification-list nicescroll">
                    <ul class="list-group list-no-border user-list" id="notifications">
                        @php
                        
            $notifications  = $user->notifications->sortByDesc('created_at');
                        @endphp             
                        @foreach($notifications as $item) 
                        <li class="list-group-item {{($item->read_at)? '' : 'active'}}">
                            @if( array_key_exists('redirect', $item->data) )
                            <a href="{{$item->data['redirect']}}?notify={{$item->id}}" class="user-list-item">
                            @else
                            <a href="#" class="user-list-item">
                            @endif
                                <div class="avatar">
                                    <img src="" alt="">
                                </div>
                                <div class="user-desc" alt="{{$item->data['text']}}" title="{{$item->data['text']}}">
                                    <span class="desc" style="    color: #000000;">{{$item->data['text']}}</span>
                                    <span class="time" style="font-size: 12px;font-weight: 700;font-style:unset;">{{$item->created_at}}</span>
                                </div>
                            </a>
                        </li>
                        @endforeach
                        {{-- <li class="list-group-item active">
                            <a href="#" class="user-list-item">
                                <div class="avatar">
                                    <img src="{{ asset('/adminto/assets/images/users/avatar-3.jpg')}}" alt="">
                                </div>
                                <div class="user-desc">
                                    <span class="name">James Anderson</span>
                                    <span class="desc">There are new settings available</span>
                                    <span class="time">2 days ago</span>
                                </div>
                            </a>
                        </li> --}}

                    </ul>
                </div>
            </div>
            <!-- /Right-bar -->

        </div>

        <audio id="chatAudio" class="hidden"><source src="/assets/notify.ogg" type="audio/ogg"><source src="/assets/notify.mp3" type="audio/mpeg"><source src="/assets/notify.wav" type="audio/wav"></audio>
@if(\Request::url() != url('/dashboard') && \Request::url() != url('/company') && \Request::url() != url('/school') )
        <!-- jQuery  -->
        <script src="{{ asset('/adminto/assets/js/jquery.min.js')}}"></script>
        <script src="{{ asset('/adminto/assets/js/bootstrap-rtl.min.js')}}"></script>
        <script src="{{ asset('/adminto/assets/js/detect.js')}}"></script>
        <script src="{{ asset('/adminto/assets/js/fastclick.js')}}"></script>
        <script src="{{ asset('/adminto/assets/js/jquery.slimscroll.js')}}"></script>
        <script src="{{ asset('/adminto/assets/js/jquery.blockUI.js')}}"></script>
        <script src="{{ asset('/adminto/assets/js/waves.js')}}"></script>
        <script src="{{ asset('/adminto/assets/js/wow.min.js')}}"></script>
        <script src="{{ asset('/adminto/assets/js/jquery.nicescroll.js')}}"></script>
        <script src="{{ asset('/adminto/assets/js/jquery.scrollTo.min.js')}}"></script>
        
<script src="/adminto/assets/plugins/switchery/switchery.min.js"></script>
        <script type="text/javascript" src="{{ asset('/adminto/assets/plugins/multiselect/js/jquery.multi-select.js')}}"></script>
        <script type="text/javascript" src="{{ asset('/adminto/assets/plugins/jquery-quicksearch/jquery.quicksearch.js')}}"></script>
        <script src="{{ asset('/adminto/assets/plugins/select2/dist/js/select2.min.js')}}" type="text/javascript"></script>


        <!-- Modal-Effect -->
        <script src="{{ asset('/adminto/assets/plugins/custombox/dist/custombox.min.js')}}"></script>
        <script src="{{ asset('/adminto/assets/plugins/custombox/dist/legacy.min.js')}}"></script>
        <!-- Toastr js -->
        <script src="{{ asset('/adminto/assets/plugins/toastr/toastr.min.js')}}"></script>
        <!-- App js -->
        <script src="{{ asset('/adminto/assets/js/jquery.core.js')}}"></script>
        <script src="{{ asset('/adminto/assets/js/jquery.app.js')}}"></script>
        <script src="{{ asset('/js/scripts.js')}}"></script>
<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>

<script>
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });
</script>
        <script>

                $("#Customer_isOwner").on("click", function () {
                    var checked = $(this).is(':checked');
                    if (checked) {
                        $(".owner-inputs").removeClass('hidden');
                    } else {
                        $(".owner-inputs").addClass('hidden');
                    }
                });

                $("#Customer_isSc").on("click", function () {
                    var checked = $(this).is(':checked');
                    if (checked) {
                        $(".owner-sc").removeClass('hidden');
                    } else {
                        $(".owner-sc").addClass('hidden');
                    }
                });

                $('#bank-plus').on('click', function () {
                    if ($('.bank-plus').hasClass('hidden')) {
                        $('.bank-plus').removeClass('hidden');
                    } else {
                        $('.bank-plus').addClass('hidden');
                    }
                    return false;
                });

                $(".select2").select2();

                
            </script>
            @if(session()->has('success'))
            <script type="text/javascript">
                
  
                toastr["success"]("تمت العملية بنجاح .")

                toastr.options = {
                  "closeButton": false,
                  "debug": false,
                  "newestOnTop": false,
                  "progressBar": false,
                  "positionClass": "toast-top-right",
                  "preventDuplicates": false,
                  "onclick": null,
                  "showDuration": "300",
                  "hideDuration": "1000",
                  "timeOut": "5000",
                  "extendedTimeOut": "1000",
                  "showEasing": "swing",
                  "hideEasing": "linear",
                  "showMethod": "fadeIn",
                  "hideMethod": "fadeOut"
                }
            </script>
            @endif
            @if(session()->has('warning'))
            <script type="text/javascript">
                
  
                toastr["warning"]("{{session()->get('warning')}}")

                toastr.options = {
                  "closeButton": false,
                  "debug": false,
                  "newestOnTop": false,
                  "progressBar": false,
                  "positionClass": "toast-top-right",
                  "preventDuplicates": false,
                  "onclick": null,
                  "showDuration": "500",
                  "hideDuration": "1000",
                  "timeOut": "5000",
                  "extendedTimeOut": "1000",
                  "showEasing": "swing",
                  "hideEasing": "linear",
                  "showMethod": "fadeIn",
                  "hideMethod": "fadeOut"
                }
            </script>
            @endif
             <script>
      var deleter = {

          linkSelector : "a#delete-btn",

          init: function() {
              $(this.linkSelector).on('click', {self:this}, this.handleClick);
          },

          handleClick: function(event) {
              event.preventDefault();

              var self = event.data.self;
              var link = $(this);

              swal({
                  title: "هل أنت متأكد؟",
                  text: "أنك تريد حذف هذا العنصر ؟",
                  icon: "warning",
                  buttons: true,
                  dangerMode: true,
              }).then(function(isConfirm){
                  if(isConfirm){
                      var cr = $('meta[name="csrf-token"]').attr('content');
                      var o = link;
                      // alert(cr);
                      $(o).append('<i class="fa fa-spin fa-spinner"></i>');
                      $.post($(o).attr('href'),{
                        _token:cr,
                        _method:'DELETE'
                      },function(data){
                        $(o).find('i').remove();
                        $(o).append('<i class="fa fa-check"></i>');
                        setTimeout(function(){
                          $(o).parent().parent().remove();
                          if(typeof cb  == 'function'){
                            cb();
                          }
                        },1000);
                      });
                  }
                  else{
                      swal("تم الالغاء", "الحذف  الغي بنجاح");
                  }
              });

          },
      };

      deleter.init();
  </script>
  <script>
      var deleterfile = {

          linkSelector : "a.delete-file",

          init: function() {
              $(this.linkSelector).on('click', {self:this}, this.handleClick);
          },

          handleClick: function(event) {
              event.preventDefault();

              var self = event.data.self;
              var link = $(this);

              swal({
                  title: "هل أنت متأكد؟",
                  text: "أنك تريد حذف هذه المنطقه ؟",
                  icon: "warning",
                  buttons: true,
                  dangerMode: true,
              }).then(function(isConfirm){
                  if(isConfirm){
                      var cr = $('meta[name="csrf-token"]').attr('content');
                      var o = link;
                      // alert(cr);
                      $(o).append('<i class="fa fa-spin fa-spinner"></i>');
                      $.post($(o).attr('href'),{
                        _token:cr,
                        _method:'DELETE'
                      },function(data){
                        $(o).find('i').remove();
                        $(o).append('<i class="fa fa-check"></i>');
                        setTimeout(function(){
                          $(o).parent().parent().remove();
                          if(typeof cb  == 'function'){
                            cb();
                          }
                        },1000);
                      });
                  }
                  else{
                      swal("تم الالغاء", "الحذف  الغي بنجاح");
                  }
              });

          },
      };

      deleterfile.init();
  </script>
  @endif
    <script>
        $(document).on('change', 'select[name=order_type]', function(){
            var o = $(this);
            $.get( "{{url('/ajax/drivers-by-type')}}" + "/" + $(this).val(), function( data ) {
                o.closest('form').find('select[name=driver_id]').html(data).select2();
            });
        });
        $(document).on('change', 'select[name=city_id]', function(){
            var o = $(this);
            $.get( "{{url('/regions')}}" + "/" + $(this).val(), function( data ) {
                o.closest('form').find('select[name=region_id]').html(data);
            });
        });
        $(document).on('change', 'select[name=region_id]', function(){
            var o = $(this);
            $.get( "{{url('/regions')}}" + "/" + $(this).val(), function( data ) {
                o.closest('form').find('select[name=district_id]').html(data);
            });
        });
    </script>
        <script src="https://js.pusher.com/4.4/pusher.min.js"></script>
        <script>

            // Enable pusher logging - don't include this in production
            Pusher.logToConsole = true;

            var pusher = new Pusher('e77bc5791324d2908ca712', {
            cluster: 'eu',
            forceTLS: true
            });

            var channel = pusher.subscribe('my-channel-{{auth()->user()->id}}');
            channel.bind('general', function(data) {
                //alert(JSON.stringify(data));
                $('#chatAudio')[0].play();
                $('#notify-sign').removeClass('hidden');
                $('#notifications').prepend(`
                <li class="list-group-item active">
                            <a href="`+data['link']+`" class="user-list-item">
                                <div class="avatar">
                                    <img src="" alt="">
                                </div>
                                <div class="user-desc" alt="`+data['message']+`" title="`+data['message']+`">
                                    <span class="desc">`+data['message']+`</span>
                                    <span class="time">`+data['date']+`</span>
                                </div>
                            </a>
                        </li>
                `);
                toastr["success"](data['message'])

                toastr.options = {
                  "closeButton": false,
                  "debug": false,
                  "newestOnTop": false,
                  "progressBar": false,
                  "positionClass": "toast-bottom-right",
                  "preventDuplicates": false,
                  "onclick": null,
                  "showDuration": "300",
                  "hideDuration": "1000",
                  "timeOut": "5000",
                  "extendedTimeOut": "1000",
                  "showEasing": "swing",
                  "hideEasing": "linear",
                  "showMethod": "fadeIn",
                  "hideMethod": "fadeOut"
                }
            });
        </script>
        
    <script src="{{ asset('/adminto/assets/plugins/mjolnic-bootstrap-colorpicker/dist/js/bootstrap-colorpicker.min.js')}}"></script>
    <script src="{{ asset('/adminto/assets/plugins/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js')}}"></script>
    <script src="{{ asset('/adminto/assets/plugins/timepicker/bootstrap-timepicker.min.js')}}">
    </script>
    <script>
        jQuery('.timepicker').timepicker().on('changeTime.timepicker', function(e) {
    var hours=e.time.hours, //Returns an integer
        min=e.time.minutes,
        merdian=e.time.meridian;
        console.log(e.time);
    if(min < 10) {
        min = '0'+min;
    }
    if(hours < 10) {
        $(e.currentTarget).val('0' + hours + ':' + min+' '+merdian);
    }
});
jQuery('.timepicker2').timepicker({
    showMeridian: false,
    showSeconds: true
}).on('changeTime.timepicker', function(e) {
    var hours=e.time.hours, //Returns an integer
        min=e.time.minutes,
        merdian=e.time.meridian;
        console.log(e.time);
    if(min < 10) {
        min = '0'+min;
    }
    if(hours < 10) {
        $(e.currentTarget).val('0' + hours + ':' + min+':00');
    }
});
    jQuery('.datepicker-input').datepicker({
        format: 'yyyy-mm-dd'
    });
    
    </script>
    
    <script>
        //    loader
        document.onreadystatechange = function () {
          var state = document.readyState
          if (state == 'interactive') {
              document.getElementById('contents').style.visibility="hidden";
          } else if (state == 'complete') {
              setTimeout(function(){
                  document.getElementById('interactive');
                  document.getElementById('load').style.visibility="hidden";
                  document.getElementById('contents').style.visibility="visible";
              },1000);
          }
      }

      $(document).on('click', '[type=submit]', function(){
         // $(this).html('<i class="fa fa-spin fa-spinner"></i>');
          // $(this).prop('disabled', true);
          // return true;
      })
  </script>
        @yield('script')
    </body>
</html>