@extends('admin.layout.app')
@section('style')
@endsection
@section('content')
<div class="row">
                   <div class="col-sm-12 m-b-15">

                        <div class="title-page sub-header-title-custom">
                            <h5 style="color: inherit;"><a href="#"><span> اداره السائقين  </span><i class="fa fa-angle-left" style="padding: 0 5px; color:inherit;"></i></a><span>{{ $driver->name }} </span></h5>
                            <div class="btn-group pull-right m-t-15">
                                <a href="/dashboard/drivers/{{$driver->id}}/edit" class="btn btn-info waves-effect w-md waves-light m-b-5">
                                    <i class="fa fa-pencil m-r-5"></i>
                                    <span>تعديل</span>
                                </a>

                                <a href="{{route('drivers.destroy',$driver)}}" id="delete-btn" class="btn btn-info btn-danger waves-effect w-md waves-light m-b-5 m-l-5">
                                    <i class="fa fa-remove"></i>
                                    <span>حذف</span>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- end row -->

                <div class="row">
                    <div class="col-lg-12">
                        <div class="panel panel-color panel-tabs panel-success">
                            <div class="panel-heading panel-heading-custom">
                                <ul class="nav nav-pills">
                                    <li class="active">
                                        <a href="#navpills-1" data-toggle="tab" aria-expanded="true">البيانات الأساسية</a>
                                    </li>

                                    <li class="">
                                        <a href="#navpills-2" data-toggle="tab" aria-expanded="false">الطلبات الحالية</a>
                                    </li>

                                    <li class="">
                                        <a href="#navpills-3" data-toggle="tab" aria-expanded="false">الطلبات السابقة</a>
                                    </li>
                                    @if ($driver->type == 'not_employee')
                                        <li class="">
                                            <a href="#navpills-4" data-toggle="tab" aria-expanded="false">الحسابات المالية</a>
                                        </li>
                                    @endif

                                    <li class="">
                                        <a href="#navpills-5" data-toggle="tab" aria-expanded="false"> ارسال تنبية</a>
                                    </li>
                                </ul>
                            </div>
                            <div class="panel-body">
                                <div class="tab-content">
                                    <div id="navpills-1" class="tab-pane fade in active">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <table class="table table-bordered table-striped text-center m-0">
                                                    <thead >
                                                        <tr>
                                                            <th class="text-center" colspan="2">البيانات الأساسية</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr>
                                                            <td>الاسم</td>
                                                            <td>{{$driver->name}}</td>
                                                        </tr>
                                                        <tr>
                                                            <td>البريد الالكتروني</td>
                                                            <td>{{$driver->email}}</td>
                                                        </tr>
                                                        <tr>
                                                            <td>رقم الجوال</td>
                                                            <td>{{$driver->phone}}</td>
                                                        </tr>
                                                        <tr>
                                                            <td>الصورة الشخصية</td>
                                                            <td>
                                                                <img src="{{GetImage($driver->image)}}" height="150" width="200">
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>رقم الهوية</td>
                                                            <td>{{$driver->national_id}}</td>
                                                        </tr>
                                                        <tr>
                                                            <td>النوع</td>
                                                            <td>
                                                                @if ($driver->type == 'not_employee')
                                                                    خارجي
                                                                @else
                                                                    داخلي
                                                                @endif
                                                            </td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>

                                            <div class="col-md-6">
                                                <table class="table table-bordered table-striped text-center m-0">
                                                    <thead >
                                                        <tr>
                                                            <th class="text-center" colspan="2">البيانات الاضافية</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr>
                                                            <td>نوع الساطحة</td>
                                                            <td>{{$driver->DriverInfo->CarCarrierType->name_ar ?? ''}}</td>
                                                        </tr>
                                                        <tr>
                                                            <td>سنة السيارة</td>
                                                            <td>{{$driver->DriverInfo->Year->name_ar ?? ''}}</td>
                                                        </tr>
                                                        <tr>
                                                            <td>لون السيارة</td>
                                                            <td>{{$driver->DriverInfo->Color->name_ar ?? ''}}</td>
                                                        </tr>
                                                        <tr>
                                                            <td>رقم لوحة السيارة</td>
                                                            <td>{{$driver->DriverInfo->car_plate_no ?? ''}}</td>
                                                        </tr>
                                                        <tr>
                                                            <td>رقم الشاصي السيارة</td>
                                                            <td>{{$driver->DriverInfo->car_chasis ?? ''}}</td>
                                                        </tr>
                                                        <tr>
                                                            <td> صورة استمارة السيارة</td>
                                                            <td>

                                                                <img src="{{GetImage($driver->DriverInfo->car_form_image ?? '') }}" height="150" width="200">
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>اسم المالك</td>
                                                            <td>{{$driver->DriverInfo->owner_name ?? ''}}</td>
                                                        </tr>
                                                        <tr>
                                                            <td>تليفون المالك</td>
                                                            <td>{{$driver->DriverInfo->owner_phone ?? ''}}</td>
                                                        </tr>
                                                        <tr>
                                                            <td>رقم بطاقة المالك</td>
                                                            <td>{{$driver->DriverInfo->owner_identity_number ?? ''}}</td>
                                                        </tr>
                                                        <tr>
                                                            <td>صورة البطاقة </td>
                                                            <td>
                                                                <img src="{{GetImage($driver->DriverInfo->identity_image ?? '') }}" height="150" width="200">
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>صورة رخصة القيادة</td>
                                                            <td>
                                                                <img src="{{GetImage($driver->DriverInfo->license_image ?? '') }}" height="150" width="200">
                                                            </td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                    <div id="navpills-2" class="tab-pane fade">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <table class="datatable-buttons table tab-pane-custom table-striped table-bordered"  style="width: 100%;">
                                                    <thead>
                                                        <tr>
                                                            <th>رقم الطلب  </th>
                                                            <th>اسم  العميل </th>
                                                            <th> رقم الجوال </th>
                                                            <th>نوع السياره </th>
                                                            <th>نوع الخدمه  </th>
                                                            <th> من </th>
                                                            <th> الى </th>
                                                           <th>تاريخ الطلب</th>
                                                            <th>الحالة </th>
                                                            <th>عرض </th>
                                                            <th>تعديل</th>
                                                            <th>حذف</th>
                                                        </tr>
                                                    </thead>

                                                    <tbody>
                                                        @foreach($current_orders as $item)
                                                        <tr>
                                                            <td>{{$item->id}}</td>
                                                            <td> {{ $item->User->name ?? '' }} </td>
                                                            <td>  {{ $item->User->phone ?? '' }} </td>
                                                            <td> {{ $item->CarType->name_ar ?? '' }} </td>
                                                            <td> {{ $item->ServiceType->name_ar ?? '' }} </td>
                                                            <td> {{ $item->SourceCity->name_ar ?? '' }} </td>
                                                            <td> {{ $item->DestinationCity->name_ar ?? '' }} </td>
                                                            <td> {{ $item->created_at ?? '' }}  </td>
                                                            <td> {{__('dashboard.'.$item->status)}} </td>

                                                            <td><a href="{{route('orders.show',$item->id)}}" ><i class="fa fa-eye  m-r-10" style="color: #188ae2;"></i> عرض</a></td>
                                                            <td><a href="{{route('orders.edit',$item->id)}}"><i class="fa fa-pencil  m-r-10" style="color: #188ae2;"></i> تعديل</a></td>
                                                            <td> <a href="{{route('orders.destroy',$item)}}" id="delete-btn" ><i class="fa fa-trash-o m-r-10" style="color: #5b69bc;"></i> حذف</a></td>
                                                        </tr>
                                                        @endforeach

                                                    </tbody>
                                                </table>
                                            </div>

                                        </div>
                                    </div>
                                    <div id="navpills-3" class="tab-pane fade">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <table class="datatable-buttons table tab-pane-custom table-striped table-bordered"  style="width: 100%;">
                                                    <thead>
                                                        <tr>
                                                            <th>رقم الطلب  </th>
                                                            <th>اسم  العميل </th>
                                                            <th> رقم الجوال </th>
                                                            <th>نوع السياره </th>
                                                            <th>نوع الخدمه  </th>
                                                            <th> من </th>
                                                            <th> الى </th>
                                                           <th>تاريخ الطلب</th>
                                                            <th>الحالة </th>
                                                            <th>عرض </th>
                                                            <th>تعديل</th>
                                                            <th>حذف</th>
                                                        </tr>
                                                    </thead>

                                                    <tbody>
                                                        @foreach($previous_orders as $item)
                                                        <tr>
                                                            <td>{{$item->id}}</td>
                                                            <td> {{ $item->User->name ?? '' }} </td>
                                                            <td>  {{ $item->User->phone ?? '' }} </td>
                                                            <td> {{ $item->CarType->name_ar ?? '' }} </td>
                                                            <td> {{ $item->ServiceType->name_ar ?? '' }} </td>
                                                            <td> {{ $item->SourceCity->name_ar ?? '' }} </td>
                                                            <td> {{ $item->DestinationCity->name_ar ?? '' }} </td>
                                                            <td> {{ $item->created_at ?? '' }}  </td>
                                                            <td> {{__('dashboard.'.$item->status)}} </td>

                                                            <td><a href="{{route('orders.show',$item->id)}}" ><i class="fa fa-eye  m-r-10" style="color: #188ae2;"></i> عرض</a></td>
                                                            <td><a href="{{route('orders.edit',$item->id)}}"><i class="fa fa-pencil  m-r-10" style="color: #188ae2;"></i> تعديل</a></td>
                                                            <td> <a href="{{route('orders.destroy',$item)}}" id="delete-btn" ><i class="fa fa-trash-o m-r-10" style="color: #5b69bc;"></i> حذف</a></td>
                                                        </tr>
                                                        @endforeach

                                                    </tbody>
                                                </table>
                                            </div>

                                        </div>
                                    </div>
                                    <div id="navpills-4" class="tab-pane fade">
                                        <div class="row">
                                            <div class="col-lg-3 col-md-6">
                                                <div class="card-box widget-user" style="background-color: #35b8e0; color: #fff;">
                                                    <div>
                                                        <div class="box-icon">
                                                            {{$driver_payments->where('type', '<>', 'income')->sum('amount')}}
                                                        </div>
                                                        <div class="wid-u-info">
                                                            <h4 class="m-t-0 m-b-5"  style="color: #fff;">
                                                                <a >  اجمالي الدفعات  </a>
                                                            </h4>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-lg-3 col-md-6">
                                                <div class="card-box widget-user" style="background-color: #35b8e0; color: #fff;">
                                                    <div>
                                                        <div class="box-icon">
                                                            {{$driver_payments->where('type', 'income')->sum('amount') - $driver_payments->where('type', '<>', 'income')->sum('amount')}}
                                                        </div>
                                                        <div class="wid-u-info">
                                                            <h4 class="m-t-0 m-b-5"  style="color: #fff;">
                                                                <a > المستحق  </a>
                                                            </h4>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-lg-3 col-md-6">
                                                <div class="card-box widget-user" style="background-color: #35b8e0; color: #fff;">
                                                    <div>
                                                        <div class="box-icon">
                                                            {{$driver_payments->where('type', 'income')->sum('amount')}}
                                                        </div>
                                                        <div class="wid-u-info">
                                                            <h4 class="m-t-0 m-b-5"  style="color: #fff;">
                                                                <a > الاجمالي  </a>
                                                            </h4>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-lg-3 col-md-6">
                                                <div class="card-box widget-user" style="background-color: #35b8e0; color: #fff;">
                                                    <div>
                                                        <div class="box-icon" style=" margin-bottom: 0; ">
                                                            <i class="fa fa-plus-circle" aria-hidden="true" style="background-color: unset; width:unset;height:unset;line-height:unset;"></i>
                                                        </div>
                                                        <div class="wid-u-info">
                                                            <h4 class="m-t-0 m-b-5" style="color: #fff;">
                                                                <a href="#0" data-toggle="modal" data-target="#add-payment" data-backdrop="static" data-keyboard="false">  إضافه دفعة  </a>
                                                            </h4>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                <table class="datatable-buttons table tab-pane-custom table-striped table-bordered"  style="width: 100%;">
                                                    <thead>
                                                        <tr>
                                                            <th>#</th>
                                                            <th> نوع العملية</th>
                                                            <th>المبلغ </th>
                                                            <th>رقم الطلب  </th>
                                                            <th>عرض تفاصيل الطلب </th>
                                                            <th>التاريخ </th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        @foreach($driver_payments as $item)
                                                        <tr>
                                                            <td>{{$item->id}}</td>
                                                            <td>
                                                                @if ($item->type == 'income')
                                                                    مستحق
                                                                @else
                                                                    دفعة مسدده
                                                                @endif
                                                            </td>
                                                            <td> {{ $item->amount ?? '' }} </td>
                                                            <td>{{$item->order_id}}</td>
                                                            <td>
                                                                @if ($item->order_id)

                                                                <a href="{{route('orders.show',$item->order_id)}}" ><i class="fa fa-eye  m-r-10" style="color: #188ae2;"></i> عرض</a></td>
                                                                @endif

                                                            <td> {{ $item->created_at ?? '' }} </td>
                                                        </tr>
                                                        @endforeach

                                                    </tbody>
                                                </table>
                                            </div>

                                        </div>
                                    </div>
                                    <div id="navpills-5" class="tab-pane fade">
                                        <div class="row">
                                            <div class="col-md-12">
                                                {!!Form::open( ['url' => '/dashboard/notifications/' ,'method' => 'Post','files' => true]) !!}
                                                <div class="col-lg-6">
                                                    <div class="form-horizontal">
                                                        <div class="form-group">
                                                            <label class="col-md-3 control-label">العنوان <span>*</span></label>
                                                            <div class="col-md-9">
                                                                {!! Form::text("title",null,['class'=>'form-control', 'placeholder' => 'العنوان', 'required' => ''])!!}
                                                            </div>
                                                        </div>
                                                        <div class="form-group">
                                                            <label class="col-md-3 control-label">المحتوي <span>*</span></label>
                                                            <div class="col-md-9">
                                                                {!! Form::textarea("content",null,['class'=>'form-control', 'placeholder' => 'المحتوي', 'required' => ''])!!}
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <input type="hidden" value="{{$driver->id}}" name="driver_id" />

                                                <div class="text-center col-md-6">
                                                    <button type="submit" class="btn blue ">ارسال</button>
                                                </div>
                                                {!!Form::close() !!}
                                            </div>

                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div><!-- end col -->
                    {{-- models --}}
                    <div id="add-payment" class="modal fade in" tabindex="-1" role="dialog" aria-labelledby="custom-width-modalLabel" aria-hidden="true">
                        <div class="modal-dialog" style="width:55%;">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                                    <h4 class="modal-title" id="custom-width-modalLabel"> اضافة دفعة </h4>
                                </div>
                                <div class="modal-body">
                                    <div class="row">
                                        <div class="col-md-12" id="modal-ajax-content">
                                            {!!Form::open( ['url' => route('driver-payments.store') ,'method' => 'Post','files' => true]) !!}
                                            {!! Form::hidden('driver_id', $driver->id, []) !!}
                                            <div class="col-lg-12">
                                                <div class="form-horizontal">
                                                    <div class="form-group">
                                                        <label class="col-md-3 control-label">المبلغ <span>*</span></label>
                                                        <div class="col-md-9">
                                                            {!! Form::number("amount",null,['class'=>'form-control', 'min' => '0', 'placeholder' => 'المبلغ', 'required' => ''])!!}
                                                        </div>
                                                    </div>

                                                </div>
                                            </div><!-- end col -->
                                            <div class="col-lg-12">
                                                <div class="panel-footer">
                                                    <div class="clearfix">
                                                        <div class="col-md-12 col-md-offset-5">
                                                            <button type="submit" class="btn blue">
                                                                <i class="fa fa-check"></i>
                                                                حفظ
                                                                </button>
                                                            <a  data-dismiss="modal" class="btn default cancel-button-panel">
                                                                <i class="fa fa-times"></i>
                                                                إلغاء الأمر
                                                            </a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            {!! Form::close() !!}
                                        </div>
                                    </div>
                                </div>
                                <div class="modal-footer">
                                </div>
                            </div><!-- /.modal-content -->
                        </div><!-- /.modal-dialog -->
                    </div>
                    {{-- models end --}}
                </div>
                <!-- end row -->

@endsection
@section('script')
@endsection
