@extends('admin.layout.app')
@section('style')
<style type="text/css">
    #mapCanvas{
        width: 100%;
        height: 300px;
    }
</style>
<style type="text/css">
    #map {
      padding: 0;
      margin: 0;
      height: 500px;
    }

    #panel {
                width: 200px;
                font-family: Arial, sans-serif;
                font-size: 13px;
                float: right;
                margin: 10px;
            }

            #color-palette {
                clear: both;
            }

            .color-button {
                width: 14px;
                height: 14px;
                font-size: 0;
                margin: 2px;
                float: left;
                cursor: pointer;
            }

            #delete-button {
                margin-top: 5px;
            }
  </style>
@endsection
@section('content')
<div class="row">
    {{--  //////////////////////////////////  --}}
                {!!Form::open( ['url' => '/dashboard/cities/' ,'method' => 'Post','files' => true,'class'=>'class1']) !!}
                @include('admin.cities.form')
                {!!Form::close() !!}
</div>
<!-- end row -->

@endsection
@section('script')

<script type="text/javascript" src="https://maps.google.com/maps/api/js?sensor=false&libraries=places&key=AIzaSyCUPprEbO25z-DXpDwe-0sA4FNwc7rI6Q0&language=ar&sensor=false&v=3.21.5a&libraries=drawing&signed_in=true&libraries=places,drawing"></script>
<script>
    var map;
function initMap() {
    map = new google.maps.Map(document.getElementById('map'), {
        center: { lat: 24.68890207347191, lng: 46.68803199999999 },
        zoom: 12,
        // only show roadmap type of map, and disable ability to switch to other type
        mapTypeId: google.maps.MapTypeId.ROADMAP,
        mapTypeControl: false
    });

    map.data.setControls(['Polygon']);
    map.data.setStyle({
        editable: true,
        draggable: true
    });
    bindDataLayerListeners(map.data);

   
    loadPolygons(map);  //load saved data
}


// Apply listeners to refresh the GeoJson display on a given data layer.
function bindDataLayerListeners(dataLayer) {
    dataLayer.addListener('addfeature', savePolygon);
    dataLayer.addListener('removefeature', savePolygon);
    //dataLayer.addListener('setgeometry', savePolygon);
}

function loadPolygons(map) {
    // var data = JSON.parse(localStorage.getItem('geoData'));


    // map.data.forEach(function (f) {
    //     map.data.remove(f);
    // });
    // map.data.addGeoJson(data)
}



function savePolygon() {
    map.data.toGeoJson(function (json) {
        // localStorage.setItem('geoData', JSON.stringify(json));
        var listArr = json['features'][0]['geometry']['coordinates'];
        console.log("json :", listArr)
        var path = '';
                    for (var i=0; i < listArr[0].length; i++) {
                      var xy = json['features'][0]['geometry']['coordinates'][0][i];
                    console.log("json point :", xy)
                      path +=xy[1] + ' ' + xy[0]+',';
                      console.log('Cordinate lat: ' + xy[0] + ' and lng: ' + xy[1] );
                    }
                    $('input[name=polygon]').val(path);
        $('input[name=polygon_data]').val(JSON.stringify(json));
        initControls(json);
    });
}

function initControls(data)
{
    var sel = document.getElementById('polyList');
    sel.options.length = 0;

    for (var i = 0; i < data.features.length; i++) {
        var opt = document.createElement('option');
        opt.innerHTML = data.features[i].geometry.type;
        opt.value = i;
        sel.appendChild(opt);
    }

    document.getElementById("btnDelete").disabled = (data.features.length === 0); 
    document.getElementById("btnDelete").onclick = function(){
                    $('input[name=polygon]').val('');
        $('input[name=polygon_data]').val(JSON.stringify(data));
        var selIdx = sel.options[sel.selectedIndex].value; //get poly index 
        data.features.splice(parseInt(selIdx), 1);   

        //reload 
        // localStorage.setItem('geoData', JSON.stringify(data));
        initControls(data);  
        loadPolygons(map);   
    };
}
initMap();


</script>
@endsection