<?php

namespace App\Models;

use Tymon\JWTAuth\Contracts\JWTSubject;
use Illuminate\Notifications\Notifiable;
use Illuminate\Foundation\Auth\User as Authenticatable;

class User extends Authenticatable implements JWTSubject
{
    use Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name', 'email', 'password', 'phone', 'national_id', 'id', 'lang', 'image', 'vip',
        'verify_code', 'verify', 'city_id', 'tax_number', 'address',
    ];
	protected $guarded = ['id'];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];
    protected $appends = [
        'vip_status', 'business_account', 'city'
    ];

    // Rest omitted for brevity

    /**
     * Get the identifier that will be stored in the subject claim of the JWT.
     *
     * @return mixed
     */
    public function getJWTIdentifier()
    {
        return $this->getKey();
    }

    /**
     * Return a key value array, containing any custom claims to be added to the JWT.
     *
     * @return array
     */
    public function getJWTCustomClaims()
    {
        return [];
    }


    public function UserVerify()
    {
        return $this->Hasmany(UserVerify::class, 'user_id');
    }

    public function Cart()
    {
        return $this->Hasmany(Cart::class, 'user_id');
    }
    public function CompanyOrder()
    {
        return $this->Hasmany(CompanyOrder::class, 'user_id');
    }
    public function OrderRating()
    {
        return $this->Hasmany(OrderRating::class, 'user_id');
    }

    // public function PlayerId()
    // {
    //     return $this->Hasmany(PlayerId::class, 'user_id');
    // }


    /**
     * Get all of the post's Files.
     */
    public function PlayerId()
    {
        return $this->morphMany(PlayerId::class, 'taggable');
    }


    public function Order()
    {
        return $this->Hasmany(Order::class, 'user_id');
    }


    public function VipCart()
    {
        return $this->Hasmany(VipCart::class, 'user_id');
    }

    public function ProductRating()
    {
        return $this->Hasmany(ProductRating::class, 'user_id');
    }


    public function BusinessAccount()
    {
        return $this->Hasone(BusinessAccount::class, 'user_id');
    }

    public function Favourite()
    {
        return $this->Hasmany(Favourite::class, 'user_id');
    }

    public function Product()
    {
        return $this->Hasmany(Product::class, 'user_id');
    }
    public function getOrdersCountAttribute()
    {
        return ''.$this->Order()->count().'';
    }
    public function getImageAttribute($img)
    {
        if($img)
        {
            return url('/').'/cdn/'.$img;
        }
        return $img;

    }

    /**
     * Get all of the post's Files.
     */
    public function Payment()
    {
        return $this->morphMany(Payment::class, 'taggable');
    }
    public function getVipStatusAttribute()
    {
        if ($this->vip && $this->BusinessAccount()->first()) {
            return 'vip';
        }elseif (!$this->vip && $this->BusinessAccount()->first()) {
            return 'under_review';
        }else{
            return 'not_vip';
        }
    }
    public function getBusinessAccountAttribute()
    {
        return $this->BusinessAccount()->first();
    }

    public function City()
    {
        return $this->belongsTo(City::class, 'city_id');
    }
    public function getCityAttribute()
    {
        return $this->City()->first();
    }
}
