<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Transaction extends Model
{
    protected $table = 'transactions';
    protected $primaryKey = 'id';
    public $sequence = 'xxccs_transactions_id_seq';
	protected $guarded = ['id'];
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'user_id', 'status', 'data', 'order_id', 'returned', 'id', 'amount',
    ];

    public function User()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function Order()
    {
        return $this->belongsTo(Order::class, 'order_id');
    }
}
