<?php

namespace App\Models;

use Illuminate\Notifications\Notifiable;
use Illuminate\Foundation\Auth\User as Authenticatable;

class Admin extends Authenticatable
{
    use Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name', 'email', 'password', 'phone', 'image',
    ];
    protected $primaryKey = 'id';
	protected $guarded = ['id'];
    public $sequence = 'xxccs_admins_id_seq';

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];
    public function UserRole()
    {
        return $this->Hasone(UserRole::class, 'admin_id');
    }
}
