<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\Driver;
use App\Models\Setting;
use App\Models\Category;
use App\Models\City;
use App\Models\Branch;
use App\Models\CarMaker;
use App\Models\CarType;
use App\Models\Product;
use App\Models\PriceList;
use App\Models\Year;
use App\Models\Color;
use App\Models\Order;
use App\Models\Coupon;
use Auth;
use DB;
use App\Traits\Api\OrderOperations;
use Carbon\Carbon;

class OrderController extends Controller
{
    public function index(Request $request)
    {
        $user = auth('api')->user();
        $orders = $user->Order();
        if ($request->has('status') && $request->get('status') != '') {
            if (!in_array($request->get('status'), ['processing', 'finished'])) {
                $orders = $orders->whereNotIn('status', ['processing', 'finished'] );
            }else{
                $orders = $orders->where('status', $request->get('status') );
            }
        }
        $orders = $orders->with('User')->get();
        return Response()->json([
            'data'          => [
                'orders'  => $orders,
            ],
            'message'       => 'success',
            'code'          => getMsgCode('success'),
        ]);
    }
    public function show(Request $request, $id)
    {
        $user = auth('api')->user();
        $order = $user->Order()
                        ->with('User')
                        ->with('OrderItem.OrderItemDay')
                        ->with('OrderItem.Product')
                        ->with('OrderItem.City')
                        ->find($id);
        // $order->created_at = $order->created_at->format('m/d/Y');
        return Response()->json([
            'data'          => [
                'order'  => $order,
            ],
            'message'       => 'success',
            'code'          => getMsgCode('success'),
        ]);
    }

    public function proceedToCheckout(Request $request)
    {
        $user = auth('api')->user();
        $cart = $user->Cart()->get();
        if ($user->Cart()->count() == 0) {
            return Response()->json([
                'data'          => new \stdClass,
                'errors'        => [trans('words.empty cart')],
                'message'       => trans('words.empty cart'),
                'code'          => getMsgCode('somethingWrong'),
            ]);
        }
        $data = $request->all();
        $data['status'] = 'init';
        $total_price = 0;
        DB::beginTransaction();
        $order = $user->Order()->create($data);
        foreach ($cart as $item ) {
            $item_data = $item->toArray();
            $product = Product::find($item->product_id);
            unset($item_data['id']);
            unset($item_data['created_at']);
            unset($item_data['updated_at']);
            if ($item_data['product_type'] == 'rent') {
                // if ($item_data['rent_type'] == 'day') {
                //     // count of days
                //     $date_from = Carbon::parse($item_data['date_from']);
                //     $date_to = Carbon::parse($item_data['date_to']);

                //     $diff_in_days = $date_from->diffInDays($date_to);
                //     if ($date_from != $date_to) {
                //         $diff_in_days++;
                //     }
                //     $item_data['price'] = $product->price;
                //     $item_data['total_price'] = $product->price * 10 * $diff_in_days* $item->quantity;
                //     $total_price += $item_data['total_price'];
                // }else{
                //     // count of hours
                //     $time_from = Carbon::parse($item_data['time_from']);
                //     $time_to = Carbon::parse($item_data['time_to']);

                //     $diff_in_hours = $time_from->diffInHours($time_to);
                //     if ($time_from != $time_to) {
                //         $diff_in_hours++;
                //     }
                //     $item_data['price'] = $product->price;
                //     $item_data['total_price'] = $product->price * $diff_in_hours* $item->quantity;
                //     $total_price += $item_data['total_price'];
                // }
                $item_data['price'] = $product->price;
                $item_data['total_price'] = 0;
                $total_price += 0;
            }else{
                $item_data['price'] = $product->price;
                $item_data['total_price'] = $product->price * $item->quantity;
                $total_price += $item_data['total_price'];
            }
            // return dd($item_data);
            if ($request->hasFile('images')) {
                foreach ($request->images as $image) {
                    $image = uploadImage($image);
                    $order->Files()->create(['name' => $image]);
                }
            }
            $order_item = $order->OrderItem()->create($item_data);

            if ($item_data['product_type'] == 'rent') {
                // array of days start
                if (isset( $item_data['rent_days'] ) && is_array(  $item_data['rent_days']  ) ) {
                    $diff_in_hours = 0;
                    foreach ($item_data['rent_days'] as $obj) {
                        $order_item->OrderItemDay()->create( $obj );
                        if ($item_data['rent_type'] == 'time') {
                            // count of hours
                            $time_from = Carbon::parse($obj['time_from']);
                            $time_to = Carbon::parse($obj['time_to']);

                            $diff_in_hours += $time_from->diffInHours($time_to);
                            if ($time_from != $time_to) {
                                $diff_in_hours++;
                            }
                        }
                    }
                    if ($item_data['rent_type'] != 'time') {
                        // count of days
                        // $date_from = Carbon::parse($item_data['date_from']);
                        // $date_to = Carbon::parse($item_data['date_to']);

                        $diff_in_days = count(  $item_data['rent_days']  ) ;
                        // if ($date_from != $date_to) {
                        //     $diff_in_days++;
                        // }
                        $item_data['price'] = $product->price;
                        $item_data['total_price'] = $product->price * 10 * $diff_in_days* $item->quantity;
                        $total_price += $item_data['total_price'];
                    }else{
                        // count of hours
                        $item_data['price'] = $product->price;
                        $item_data['total_price'] = $product->price * $diff_in_hours* $item->quantity;
                        $total_price += $item_data['total_price'];
                    }
                    $order_item->update($item_data);
                }else if (isset( $item_data['rent_type'] ) && $item_data['rent_type'] == 'time' ) {
                    $diff_in_hours = 0;
                    $obj = $item_data['rent_day_time'];
                        $order_item->OrderItemDay()->create( $obj );
                        if ($item_data['rent_type'] != 'day') {
                            // count of hours
                            $time_from = Carbon::parse($obj['time_from']);
                            $time_to = Carbon::parse($obj['time_to']);

                            $diff_in_hours += $time_from->diffInHours($time_to);
                            if ($time_from != $time_to) {
                                $diff_in_hours++;
                            }
                        }
                        // count of hours
                        $item_data['price'] = $product->price;
                        $item_data['total_price'] = $product->price * $diff_in_hours* $item->quantity;
                        $total_price += $item_data['total_price'];
                    $order_item->update($item_data);
                }
                // array of days end
            }
            $product->decrement('quantity', $item->quantity);
        }
        $total_price = $this->getCart()['total_price'];
        $order->update(['total_price' => $total_price ]);
        $msg = 'success';
        if ($request->has('coupon') && $request->get('coupon') != '') {
            $coupon = Coupon::where('coupon', $request->get('coupon'))->where('active', '1')->first();
            if ($coupon) {
                if ($coupon->Order()->count() >= $coupon->benefits) {
                    $msg = 'coupon benefits ended';
                }else{
                    $percent = $coupon->amount;
                    $discount = $total_price / 100 * $percent;
                    $order->update([
                        'discount' => $discount,
                        'original_total' => $total_price,
                        'gasoline_cost' => $this->getCart()['gasoline_cost'],
                        'move_cost' => $this->getCart()['move_cost'],
                        'total_price' => $total_price - $discount,
                        ]);
                }
            } else {
                $msg = 'coupon not found';
            }
        }
        $user->Cart()->delete();
        
        $order->client_code = mt_rand(100000,999999);
        $order->save();
        DB::commit();
        $order = Order::find($order->id);
        HelpersendSMS($order->User->phone ?? '', "Client Code: ".$order->client_code);
        
        return Response()->json([
            'data'          => [
                'order'  => $order,
            ],
            'message'       => $msg,
            'code'          => getMsgCode('success'),
        ]);
    }
    public function createOrder(Request $request)
    {
        $user = auth('api')->user();
        $cart = $user->Cart()->get();
        if ($user->Cart()->count() == 0) {
            return Response()->json([
                'data'          => new \stdClass,
                'errors'        => [trans('words.empty cart')],
                'message'       => trans('words.empty cart'),
                'code'          => getMsgCode('somethingWrong'),
            ]);
        }
        $data = $request->all();
        $data['status'] = 'init';
        $data['gasoline_cost'] = $this->getCart()['gasoline_cost'];
        $data['move_cost'] = $this->getCart()['move_cost'];
        $data['housing_cost'] = $this->getCart()['housing_cost'];
        $data['original_total'] = $this->getCart()['sub_total_price'];
        $data['total_price'] = $this->getCart()['total'];
        // return $data;
        DB::beginTransaction();
        $order = $user->Order()->create($data);
        foreach ($cart as $item) {
            $product = $item->Product()->first();
            $row = $item->toArray();
            //
            $product = $item->Product()->first();
        $total_price2 = 0;
        if ($item->product_type == 'rent') {
            //
            if ($item->rent_type == 'day') {
                $total_price2 += $item->CartItemDay()->count() * $product->daily_price;
            } else if ($item->rent_type == 'month') {
                $total_price2 += $item->months * $product->price;
                // dd($item->months);
            } else {
                if ($item->CartItemDay()->first()) {

                    $from = Carbon::createFromFormat('Y-m-d H:s:i', $item->CartItemDay()->first()->day_date . ' ' . $item->CartItemDay()->first()->time_from);
                    $to = Carbon::createFromFormat('Y-m-d H:s:i', $item->CartItemDay()->first()->day_date . ' ' . $item->CartItemDay()->first()->time_to);
                    $diff_in_hours = $to->diffInHours($from);
                    $total_price2 += $diff_in_hours * $product->hour_price;
                }
            }

        }else{
            $total_price2 +=  $item->Product->price;
        }
        $row['price'] =$total_price2;
        $row['gasoline_cost'] = PriceWithVat($item->gasoline_cost);
        $row['move_cost'] = PriceWithVat($item->move_cost);
        $row['housing_cost'] = PriceWithVat($item->housing_cost);
        $total_price2 = $item->quantity * $total_price2;
        $row['total_price'] =$total_price2 +PriceWithVat( ($item->move_cost ?? 0) + ($item->gasoline_cost ?? 0) + ($item->housing_cost ?? 0) ) ;
            //
            $ele = $order->OrderItem()->create($row);
            if ($item->product_type == 'rent') {
                $ele->update([
                    'date_from' => $item->CartItemDay()->min('day_date'),
                    'date_to' => $item->CartItemDay()->max('day_date'),
                ]);
                // array of days start
                if ( $item->CartItemDay()->count() > 0 ) {
                    foreach ($item->CartItemDay()->get() as $obj) {
                        $ele->OrderItemDay()->create( $obj->toArray() );

                    }
                }
                // array of days end
            }
            $product->decrement('quantity', $item->quantity);
        }
        $msg = 'success';
        if ($request->has('coupon') && $request->get('coupon') != '') {
            $coupon = Coupon::where('coupon', $request->get('coupon'))->where('active', '1')->first();
            if ($coupon) {
                if ($coupon->Order()->count() >= $coupon->benefits) {
                    $msg = 'coupon benefits ended';
                }else{
                    $percent = $coupon->amount;
                    $discount = $order->original_total / 100 * $percent;
                    $order->update([
                        'discount' => $discount,
                        'total_price' => $order->total_price - $discount,
                        ]);
                }
            } else {
                $msg = 'coupon not found';
            }
        }
        $user->Cart()->delete();
        
        $order->client_code = mt_rand(100000,999999);
        $order->save();
        DB::commit();
        $order = Order::find($order->id);
        
        HelpersendSMS($order->User->phone ?? '', "Client Code: ".$order->client_code);
        return Response()->json([
            'data'          => [
                'order'  => $order,
            ],
            'message'       => $msg,
            'code'          => getMsgCode('success'),
        ]);
    }

    public function getCart()
    {
        $user = auth('api')->user();
        $city_id = $user->city_id;
        $move_cost = 0;//$user->Cart()->sum('move_cost');
        $gasoline_cost = $user->Cart()->sum('gasoline_cost');
        $cart = $user->Cart()->with('Product')->get();
        $total_price = 0;
        foreach ($cart as $item) {
            $product = $item->Product()->first();
            if ($product) {

                if ($item->product_type == 'rent') {
                    //
                    if ($item->rent_type == 'day') {
                        $total_price += $item->CartItemDay()->count() * $product->daily_price;
                    }elseif ($item->rent_type == 'month') {
                        $total_price += $item->months * $product->price;
                    }  else {
                        if ($item->CartItemDay()->first()) {

                            $from = Carbon::createFromFormat('Y-m-d H:s:i', $item->CartItemDay()->first()->day_date . ' ' . $item->CartItemDay()->first()->time_from);
                            $to = Carbon::createFromFormat('Y-m-d H:s:i', $item->CartItemDay()->first()->day_date . ' ' . $item->CartItemDay()->first()->time_to);
                            $diff_in_hours = $to->diffInHours($from);
                            $total_price += $diff_in_hours * $product->hour_price;
                        }
                    }
                    if ($city_id && $product->ProductCity()->where('city_id', $city_id)->first() ) {
                        $move_cost2 = $product->ProductCity()->where('city_id', $city_id)->first()->cost;
                    }else{
                        $move_cost2 = 0;
                    }
                    $move_cost += $move_cost2;

                }else{
                    $total_price += $item->quantity * $item->Product->price;
                }
            }
        }
        if ($user->Cart()->first()) {
            $type = $user->Cart()->first()->product_type;
        } else {
            $type = null;
        }
        $sub_total = $total_price ;
        $all_total = $total_price + PriceWithVat($cart->sum('gasoline_cost')) + PriceWithVat($cart->sum('move_cost')) + PriceWithVat($cart->sum('housing_cost'));

        $b_tax_total = $all_total / (100 + (float)getSettingValue('tax')) * 100;
        return [
                'cart'  =>  $cart,
                'move_cost' => PriceWithVat($cart->sum('move_cost')),
                'gasoline_cost' => PriceWithVat($cart->sum('gasoline_cost')),
                'housing_cost' => PriceWithVat($cart->sum('housing_cost')),
                'sub_total_price' => $sub_total,
                // 'sub_total_price' => $b_tax_total,
                'vat' => round((float)getSettingValue('tax'),2),
                'vat_cost' => round($all_total - $b_tax_total,2),
                'total' => $all_total,
                'type'  => $type,
            ];
        // return [
        //         'cart'  => $cart,
        //         'sub_total_price'  => $total_price,
        //         'total_price'  => $total_price + $move_cost + $gasoline_cost + (round((float)getSettingValue('tax'),2) / 100 * $total_price),
        //         'move_cost'  => $move_cost,
        //         'vat'  => round((float)getSettingValue('tax'),2),
        //         'vat_cost'  => round((float)getSettingValue('tax'),2) / 100 * $total_price,
        //         'gasoline_cost'  => round($gasoline_cost,2),
        //         'type'  => $type,
        //     ];
    }
    public static function add_order(Request $request)
    {
        $user = auth('api')->user();
        $cart = $user->Cart()->get();
        if ($user->Cart()->count() == 0) {
            return Response()->json([
                'data'          => new \stdClass,
                'errors'        => [trans('words.empty cart')],
                'message'       => trans('words.empty cart'),
                'code'          => getMsgCode('somethingWrong'),
            ]);
        }
        $data = $request->all();
        $data['status'] = 'init';
        $total_price = 0;
        DB::beginTransaction();
        $order = $user->Order()->create($data);
        foreach ($cart as $item ) {
            $item_data = $item->toArray();
            $product = Product::find($item->product_id);
            unset($item_data['id']);
            unset($item_data['created_at']);
            unset($item_data['updated_at']);
            if ($item_data['product_type'] == 'rent') {
                $item_data['price'] = $product->price;
                $item_data['total_price'] = 0;
                $total_price += 0;
            }else{
                $item_data['price'] = $product->price;
                $item_data['total_price'] = $product->price * $item->quantity;
                $total_price += $item_data['total_price'];
            }
            // return dd($item_data);

            $order_item = $order->OrderItem()->create($item_data);

            if ($item_data['product_type'] == 'rent') {
                // array of days start
                if (isset( $item_data['rent_days'] ) && is_array(  $item_data['rent_days']  ) ) {
                    $diff_in_hours = 0;
                    foreach ($item_data['rent_days'] as $obj) {
                        $order_item->OrderItemDay()->create( $obj );
                        if ($item_data['rent_type'] != 'day') {
                            // count of hours
                            $time_from = Carbon::parse($obj['time_from']);
                            $time_to = Carbon::parse($obj['time_to']);

                            $diff_in_hours += $time_from->diffInHours($time_to);
                            if ($time_from != $time_to) {
                                $diff_in_hours++;
                            }
                        }
                    }
                    if ($item_data['rent_type'] == 'day') {
                        // count of days
                        // $date_from = Carbon::parse($item_data['date_from']);
                        // $date_to = Carbon::parse($item_data['date_to']);

                        $diff_in_days = count(  $item_data['rent_days']  ) ;
                        // if ($date_from != $date_to) {
                        //     $diff_in_days++;
                        // }
                        $item_data['price'] = $product->price;
                        $item_data['total_price'] = $product->price * 10 * $diff_in_days* $item->quantity;
                        $total_price += $item_data['total_price'];
                    }else{
                        // count of hours
                        $item_data['price'] = $product->price;
                        $item_data['total_price'] = $product->price * $diff_in_hours* $item->quantity;
                        $total_price += $item_data['total_price'];
                    }
                    $order_item->update($item_data);
                }else if (isset( $item_data['rent_type'] ) && $item_data['rent_type'] == 'time' ) {
                    $diff_in_hours = 0;
                    $obj = $item_data['rent_day_time'];
                        $order_item->OrderItemDay()->create( $obj );
                        if ($item_data['rent_type'] != 'day') {
                            // count of hours
                            $time_from = Carbon::parse($obj['time_from']);
                            $time_to = Carbon::parse($obj['time_to']);

                            $diff_in_hours += $time_from->diffInHours($time_to);
                            if ($time_from != $time_to) {
                                $diff_in_hours++;
                            }
                        }
                        // count of hours
                        $item_data['price'] = $product->price;
                        $item_data['total_price'] = $product->price * $diff_in_hours* $item->quantity;
                        $total_price += $item_data['total_price'];
                    $order_item->update($item_data);
                }
                // array of days end
            }
        }
        $order->update(['total_price' => $total_price ]);
        if ($request->has('coupon') && $request->get('coupon') != '') {
            $coupon = Coupon::where('coupon', $request->get('coupon'))->where('active', '1')->first();
            if ($coupon) {
                if ($coupon->Order()->count() >= $coupon->benefits) {
                    $msg = 'coupon benefits ended';
                }else{
                    $percent = $coupon->amount;
                    $discount = $total_price / 100 * $percent;
                    $order->update([
                        'discount' => $discount,
                        'original_total' => $total_price,
                        'total_price' => $total_price - $discount,
                        ]);
                }
            } else {
                $msg = 'coupon not found';
            }

        }
        // $order->update(['total_price' => $total_price ]);
        $user->Cart()->delete();
        
        $order->client_code = mt_rand(100000,999999);
        $order->save();
        DB::commit();
        $order = Order::find($order->id);
        
        HelpersendSMS($order->User->phone ?? '', "Client Code: ".$order->client_code);
        // DB::commit();
        return $order;
    }
    public function destroy($id)
    {
        $user = auth('api')->user();
        $order = $user->Order()->where('status', 'init')->find($id);
        if ($order) {
            $order->OrderItem()->delete();
            $order->delete();
        }
        return Response()->json([
            'data'          => new \stdClass,
            'message'       => 'success',
            'code'          => getMsgCode('success'),
        ]);
    }
    public function Payment(Request $request)
    {

        $user = auth('api')->user();
        $order = $user->Order()->find($request->order_id);
        if ($order) {
            if ($request->payment =='success') {
                $order->update(['status' => 'confirmed']);
            }else{
                $order->update(['status' => 'init']);

            }
        }
        return Response()->json([
            'data'          => new \stdClass,
            'message'       => 'success',
            'code'          => getMsgCode('success'),
        ]);
    }

}
