<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Resources\CartItemResource;
use App\Http\Resources\CartResource;
use App\Models\Product;
use App\Models\Cart;
use Carbon\Carbon;

class CartNoAuthController extends Controller
{
    public function addToCart(Request $request)
    {
        $uuid = Request()->header('uuid');
        $data = $request->all();
        if ($request->has('empty') && $request->empty == '1') {
            if (Cart::where('uuid', $uuid)->whereNotNull('coupon')->count() > 0) {
                $data['coupon'] = Cart::where('uuid', $uuid)->whereNotNull('coupon')->first()->coupon;
            }
            Cart::where('uuid', $uuid)->delete();
        }
        $city_id = $request->city_id;
        // check product type
        $product = Product::find($request->get('product_id'));
        if (!$product) {
            return Response()->json([
                'data'          => new \stdClass,
                'errors'        => [trans('words.product not found')],
                'message'       => trans('words.product not found'),
                'code'          => getMsgCode('notFound'),
            ]);
        }
        if (Cart::where('uuid', $uuid)->where('product_type', '<>', $product->type)->count() > 0 ) {
            return Response()->json([
                'data'          => new \stdClass,
                'errors'        => [trans('words.different types not allowed in cart.')],
                'message'       => trans('words.different types not allowed in cart.'),
                'code'          => getMsgCode('somethingWrong'),
            ]);
        }
        // check product exist
        if ($item = Cart::where('uuid', $uuid)->where('product_id', $product->id)->first() ) {
            $data['product_type'] = $product->type;
            if($product->quantity && ($item->quantity + $request->quantity) > $product->quantity)
            {
                return Response()->json([
                    'data'          => new \stdClass,
                    'errors'        => [trans('words.quantity not available')],
                    'message'       => trans('words.quantity not available'),
                    'code'          => getMsgCode('somethingWrong'),
                ]);
            }
            $data['quantity'] = $request->quantity;
            // $data['quantity'] = $item->quantity + $request->quantity;
            $item->update($data);
        }else{
            $data['product_type'] = $product->type;
            $data['uuid'] = $uuid;
            if($product->quantity && $request->quantity > $product->quantity)
            {
                return Response()->json([
                    'data'          => new \stdClass,
                    'errors'        => [trans('words.quantity not available')],
                    'message'       => trans('words.quantity not available'),
                    'code'          => getMsgCode('somethingWrong'),
                ]);
            }
            $item = Cart::create($data);
        }
        $item->CartItemDay()->delete();
        if ($data['product_type'] == 'rent') {
            // if ($request->has('city_id') && $product->ProductCity()->where('city_id', $request->city_id)->first()) {
            //     $move_cost = $product->ProductCity()->where('city_id', $request->city_id)->first()->cost;
            // }else{
            //     $move_cost = 0;
            // }
            // $item->update(['move_cost' => $move_cost]);
            // array of days start
            if ($data['rent_type'] == 'day' && isset( $data['rent_days'] ) && is_array(  $data['rent_days']  ) ) {
                foreach ($data['rent_days'] as $day) {
                    $item->CartItemDay()->create( ['day_date' => $day] );
                }
                if ($request->has('gasoline_cost') && $request->gasoline_cost == '1') {
                    $data['gasoline_cost'] = sizeof($data['rent_days']) * $product->gasoline * (float)getSettingValue('gasoline_cost') * getHoursCount();
                }
                if ($request->has('housing_cost') && $request->housing_cost == '1') {
                    if (sizeof($data['rent_days']) > 1) {

                        $data['housing_cost'] = sizeof($data['rent_days']) *(float)getSettingValue('housing_cost');
                    }
                }
                if ($request->has('move_cost') && $request->move_cost == '1' && $city_id && $product->ProductCity()->where('city_id', $city_id)->first()) {
                    $data['move_cost'] = $product->ProductCity()->where('city_id', $city_id)->first()->cost * $data['quantity'];
                }
                // $pro_price = sizeof($data['rent_days']) * $product->daily_price;
            }elseif ($data['rent_type'] == 'time' && isset( $data['rent_day_time'] ) && is_array(  $data['rent_day_time']  ) ) {
                    $item->CartItemDay()->create( $data['rent_day_time'] );
                    $from = Carbon::createFromFormat('Y-m-d H:s:i', $data['rent_day_time']['day_date'] . ' ' . $data['rent_day_time']['time_from']);
                    $to = Carbon::createFromFormat('Y-m-d H:s:i', $data['rent_day_time']['day_date'] . ' ' . $data['rent_day_time']['time_to']);
                    $diff_in_hours = $to->diffInHours($from);
                    if ($request->has('gasoline_cost') && $request->gasoline_cost == '1') {
                        $data['gasoline_cost'] =  $product->gasoline * (float)getSettingValue('gasoline_cost') * $diff_in_hours;
                    }
                    if ($request->has('move_cost') && $request->move_cost == '1' && $city_id && $product->ProductCity()->where('city_id', $city_id)->first()) {
                        $data['move_cost'] = $product->ProductCity()->where('city_id', $city_id)->first()->cost * $data['quantity'];
                    }
                    $data['housing_cost'] = 0;
                $pro_price = $diff_in_hours * $product->hour_price;
            }elseif ($data['rent_type'] == 'month' && isset( $data['start_date'] ) && isset( $data['months'] ) ) {
                $item->update(['months' => $data['months']]);
                $app = new AppInfoController;
                foreach ($app->getHolidays( $data['start_date'], Carbon::parse($data['start_date'])->addMonths($data['months']), $data['months'])['res'] as $day) {
                    $item->CartItemDay()->create( ['day_date' => $day] );
                }
                if ($request->has('gasoline_cost') && $request->gasoline_cost == '1') {
                    $data['gasoline_cost'] = sizeof($app->getHolidays( $data['start_date'], Carbon::parse($data['start_date'])->addMonths($data['months']), $data['months'])['res']) * $product->gasoline * (float)getSettingValue('gasoline_cost') * getHoursCount();
                }
                if ($request->has('housing_cost') && $request->housing_cost == '1') {
                    if (sizeof($app->getHolidays( $data['start_date'], Carbon::parse($data['start_date'])->addMonths($data['months']), $data['months'])['res']) > 1) {

                        $data['housing_cost'] = sizeof($app->getHolidays( $data['start_date'], Carbon::parse($data['start_date'])->addMonths($data['months']), $data['months'])['res']) *(float)getSettingValue('housing_cost');
                    }
                }
                if ($request->has('move_cost') && $request->move_cost == '1' && $city_id && $product->ProductCity()->where('city_id', $city_id)->first()) {
                    $data['move_cost'] = $product->ProductCity()->where('city_id', $city_id)->first()->cost * $data['quantity'];
                    // dd($data['move_cost']);
                }else{
                    $data['move_cost'] = 0;
                }
            }
            $item->update(['gasoline_cost' => @$data['gasoline_cost'], 'housing_cost' => @$data['housing_cost'], 'move_cost' => @$data['move_cost'] ]);
        }

        return $this->viewCart($request);
        /*
        $move_cost = Cart::where('uuid', $uuid)->sum('move_cost');
        $gasoline_cost = Cart::where('uuid', $uuid)->sum('gasoline_cost');
        $cart = Cart::where('uuid', $uuid)->with('Product')->get();
        $total_price = 0;
        foreach ($cart as $item) {
            $product = $item->Product()->first();
            if ($product) {

                if ($item->product_type == 'rent') {
                    //
                    if ($item->rent_type == 'day') {
                        $total_price += $item->CartItemDay()->count() * $product->daily_price;
                    } else {
                        if ($item->CartItemDay()->first()) {

                            $from = Carbon::createFromFormat('Y-m-d H:s:i', $item->CartItemDay()->first()->day_date . ' ' . $item->CartItemDay()->first()->time_from);
                            $to = Carbon::createFromFormat('Y-m-d H:s:i', $item->CartItemDay()->first()->day_date . ' ' . $item->CartItemDay()->first()->time_to);
                            $diff_in_hours = $to->diffInHours($from);
                            $total_price += $diff_in_hours * $product->hour_price;
                        }
                    }
                if ($request->has('city_id') && $product->ProductCity()->where('city_id', $request->city_id)) {
                    $move_cost2 = $product->ProductCity()->where('city_id', $request->city_id)->first()->cost;
                }else{
                    $move_cost2 = 0;
                }
                $move_cost += $move_cost2;

                }else{
                    $total_price += $item->quantity * $item->Product->price;
                }
            }
        }
        return Response()->json([
            'data'          => [
                'cart'  => $cart,
                'sub_total_price'  => $total_price,
                'total_price'  => $total_price + $move_cost + $gasoline_cost + (round((float)getSettingValue('tax'),2) / 100 * $total_price),
                'move_cost'  => $move_cost,
                'vat'  => round((float)getSettingValue('tax'),2),
                'vat_cost'  => round((float)getSettingValue('tax'),2) / 100 * $total_price,
                'gasoline_cost'  => $gasoline_cost,
            ],
            'message'       => 'success',
            'code'          => getMsgCode('success'),
        ]);
        */
    }
    public function viewCart(Request $request)
    {
        $uuid = Request()->header('uuid');
        if (!$uuid) {
            return Response()->json([
                'data'          => new \stdClass,
                'message'       => 'notFound',
                'code'          => getMsgCode('notFound'),
            ]);
        }
        $move_cost = 0;//Cart::where('uuid', $uuid)->sum('move_cost');
        $gasoline_cost =  Cart::where('uuid', $uuid)->sum('gasoline_cost');

        $housing_cost = Cart::where('uuid', $uuid)->sum('housing_cost');
        $cart = Cart::where('uuid', $uuid)->with('Product')->get();

        $total_price = 0;
        foreach ($cart as $item) {
            $product = $item->Product()->first();
            if ($product) {

                if ($item->product_type == 'rent') {
                    //
                    if ($item->rent_type == 'day') {
                        $total_price += $item->CartItemDay()->count() * $product->daily_price;
                    } else if ($item->rent_type == 'month') {
                        $total_price += $item->months * $product->price;
                    } else {
                        if ($item->CartItemDay()->first()) {

                            $from = Carbon::createFromFormat('Y-m-d H:s:i', $item->CartItemDay()->first()->day_date . ' ' . $item->CartItemDay()->first()->time_from);
                            $to = Carbon::createFromFormat('Y-m-d H:s:i', $item->CartItemDay()->first()->day_date . ' ' . $item->CartItemDay()->first()->time_to);
                            $diff_in_hours = $to->diffInHours($from);
                            $total_price += $diff_in_hours * $product->hour_price;
                        }
                    }
                if ($request->has('city_id') && $product->ProductCity()->where('city_id', $request->city_id)->first()) {
                    $move_cost2 = $product->ProductCity()->where('city_id', $request->city_id)->first()->cost * $item->quantity;
                }else{
                    $move_cost2 = 0;
                }
                $move_cost += $move_cost2;

                }else{
                    $total_price += $item->Product->price;
                }
                $total_price = $item->quantity * $total_price;
            }
        }
        if (Cart::where('uuid', $uuid)->first()) {
            $type = Cart::where('uuid', $uuid)->first()->product_type;
        } else {
            $type = null;
        }

        $sub_total = $total_price ;
        $all_total = $total_price + PriceWithVat($cart->sum('gasoline_cost')) + PriceWithVat($cart->sum('move_cost')) + PriceWithVat($cart->sum('housing_cost'));

        // $b_tax_total = $all_total / (100 + (float)getSettingValue('tax')) * 100;
        $b_tax_total2 = $all_total / (100 + (float)getSettingValue('tax')) * 100;
        $b_tax_total = $sub_total / (100 + (float)getSettingValue('tax')) * 100;
        return Response()->json([
            'data'          => [
                'cart_count' => $cart->count(),
                'coupon' => '',
                'coupon_discount_percent' => 0,
                'coupon_discount_value' => 0,
                'cart'  =>  CartItemResource::collection($cart),
                'move_cost' => $cart->sum('move_cost'),
                'gasoline_cost' => $cart->sum('gasoline_cost'),
                'housing_cost' => $cart->sum('housing_cost'),
                'sub_total_price' => $b_tax_total,
                'vat' => round((float)getSettingValue('tax'),2),
                'vat_cost' => round($all_total - $b_tax_total2,2),
                'total' => $all_total,
                'type'  => $type,
            ],
            'message'       => 'success',
            'code'          => getMsgCode('success'),
        ]);
    }
    public function removeFromCart(Request $request)
    {
        $uuid = Request()->header('uuid');
        $product = Product::find($request->get('product_id'));
        if (!$product) {
            return Response()->json([
                'data'          => new \stdClass,
                'errors'        => [trans('words.product not found')],
                'message'       => trans('words.product not found'),
                'code'          => getMsgCode('notFound'),
            ]);
        }
        Cart::where('uuid', $uuid)->where('product_id', $product->id)->delete();
        return $this->viewCart($request);
        // $move_cost = Cart::where('uuid', $uuid)->sum('move_cost');
        // $gasoline_cost = Cart::where('uuid', $uuid)->sum('gasoline_cost');
        // $cart = Cart::where('uuid', $uuid)->with('Product')->get();
        // $total_price = 0;
        // foreach ($cart as $item) {
        //     $total_price += $item->quantity * $item->Product->price;
        // }
        // return Response()->json([
        //     'data'          => [
        //         'cart'  => $cart,
        //         'sub_total_price'  => $total_price,
        //         'total_price'  => $total_price + $move_cost + $gasoline_cost + (round((float)getSettingValue('tax'),2) / 100 * $total_price),
        //         'move_cost'  => $move_cost,
        //         'vat'  => round((float)getSettingValue('tax'),2),
        //         'vat_cost'  => round((float)getSettingValue('tax'),2) / 100 * $total_price,
        //         'gasoline_cost'  => $gasoline_cost,
        //     ],
        //     'message'       => 'success',
        //     'code'          => getMsgCode('success'),
        // ]);
    }
    public function updateCartItem(Request $request, $id)
    {
        $uuid = Request()->header('uuid');
        $data = $request->all();
        Cart::where('uuid', $uuid)->where('id', $id)->update($data);
        return $this->viewCart($request);
    }
}
