<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\Admin\UpdateProductRequest;
use App\Http\Requests\Admin\StoreProductRequest;
use App\Http\Controllers\Controller;
use App\Traits\Admin\ProductOperations;
use Illuminate\Http\Request;
use App\Models\Admin;
use App\Models\Product;
use Auth;
use Validator;
use Maatwebsite\Excel\Facades\Excel;
use App\Imports\ProductImport;
use App\Exports\GeneralExport;
use Carbon\Carbon;
use DB;

class ProductController extends Controller
{
    use ProductOperations;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function __construct()
    {
        // $this->middleware('Permission:Product_show'    , ['only' => 'index', 'show']);
        // $this->middleware('Permission:Product_add'     , ['only' => 'create', 'store']);
        // $this->middleware('Permission:Product_edit'    , ['only' => 'edit', 'update']);
        // $this->middleware('Permission:Product_delete'  , ['only' => 'destroy']);
    }

    public function index()
    {
        $products = Product::latest();
        $search = array();
        if (Request()->has('title') && Request()->get('title') != '') {
            $title = Request()->get('title');
            $search['title'] = $title;

            $products = $products->where('title' , 'LIKE' ,'%'.$title.'%' );
        }
        if (Request()->has('model') && Request()->get('model') != '') {
            $model = Request()->get('model');
            $search['model'] = $model;

            $products = $products->where('model' , 'LIKE' ,'%'.$model.'%' );
        }
        if (Request()->has('maker_company') && Request()->get('maker_company') != '') {
            $maker_company = Request()->get('maker_company');
            $search['maker_company'] = $maker_company;

            $products = $products->where('maker_company' , 'LIKE' ,'%'.$maker_company.'%' );
        }
        if (Request()->has('id') && Request()->get('id') != '') {
            $id = Request()->get('id');
            $search['id'] = $id;
            $products = $products->where('product_number' ,'LIKE'     ,"%$id%");
        }
        if (Request()->has('status') && Request()->get('status') != '') {
            $status = Request()->get('status');
            $search['status'] = $status;
            $products = $products->where('status',$status);
        }
        if (Request()->has('type') && Request()->get('type') != '') {
            $type = Request()->get('type');
            $search['type'] = $type;
            $products = $products->where('type',$type);
        }
        if (Request()->has('category') && Request()->get('category') != '') {
            $category = Request()->get('category');
            $search['category'] = $category;
            $products = $products->where('category_id',$category);
        }
        if (Request()->has('excel') && Request()->get('excel') != '') {
            $products = $products->get();
            return Excel::download(new GeneralExport('admin.products.excel', $products), 'products-'.Carbon::now()->toDateString().'.xlsx');
        }
        $products = $products->paginate(40);

        $title = 'المعدات';
        return view('admin.products.index', compact('products', 'title', 'search'));
    }
    public function indexPost(Request $request)
    {
        $products = Product::whereNotNull('id');
        $search = array();
        if ($request->has('sort_by') && $request->sort_by != '') {
            $products = $products->orderBy($request->sort_by, $request->sort_type);
            $search['sort_by'] = $request->sort_by;
            $search['sort_type'] = $request->sort_type;
        }else{
            $products = $products->latest();
        }
        if (Request()->has('title') && Request()->get('title') != '') {
            $title = Request()->get('title');
            $search['title'] = $title;

            $products = $products->where('title' , 'LIKE' ,'%'.$title.'%' );
        }
        if (Request()->has('model') && Request()->get('model') != '') {
            $model = Request()->get('model');
            $search['model'] = $model;

            $products = $products->where('model' , 'LIKE' ,'%'.$model.'%' );
        }
        if (Request()->has('maker_company') && Request()->get('maker_company') != '') {
            $maker_company = Request()->get('maker_company');
            $search['maker_company'] = $maker_company;

            $products = $products->where('maker_company' , 'LIKE' ,'%'.$maker_company.'%' );
        }
        if (Request()->has('id') && Request()->get('id') != '') {
            $id = Request()->get('id');
            $search['id'] = $id;
            $products = $products->where('product_number' ,'LIKE'     ,"%$id%");
        }
        if (Request()->has('status') && Request()->get('status') != '') {
            $status = Request()->get('status');
            $search['status'] = $status;
            $products = $products->where('status',$status);
        }
        if (Request()->has('type') && Request()->get('type') != '') {
            $type = Request()->get('type');
            $search['type'] = $type;
            $products = $products->where('type',$type);
        }
        if (Request()->has('category') && Request()->get('category') != '') {
            $category = Request()->get('category');
            $search['category'] = $category;
            $products = $products->where('category_id',$category);
        }
        if (Request()->has('excel') && Request()->get('excel') != '') {
            $products = $products->get();
            return Excel::download(new GeneralExport('admin.products.excel', $products), 'products-'.Carbon::now()->toDateString().'.xlsx');
        }
        $products = $products->paginate(40)->setPath(route('products.index'));

        $title = 'المعدات';
        $view = view('admin.products.table', compact('products', 'title', 'search'))->render();
        return response()->json([
            'code' => 200,
            'view' => $view
        ], 200);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $title = 'اضافة طلب';
        return view('admin.products.add', compact('title'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreProductRequest $request)
    {
        // return $request->all();
        $product = $this->register($request);
        return redirect('/dashboard/products?type='.$product->type)->with('success', 'data added successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Product $product)
    {
        $title = 'عرض طلب';
        return view('admin.products.show', compact('product', 'title'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $title = 'تعديل طلب';
        $product = Product::find($id);
        return view('admin.products.edit', compact('product', 'title'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateProductRequest $request, Product $product)
    {
        // $product = Product::find($id);
        $product = $this->UpdateRecords($product, $request);
        return redirect('/dashboard/products?type='.$product->type)->with('success', 'data added successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Product $product)
    {
        // if ($product->image) {
            // @unlink(public_path('/cdn/'.$product->image));
            // @unlink(public_path('/cdn/'.$product->product_number.'/'.$product->image));
            $dirPath = public_path('/cdn/products/'.$product->product_number);
            $files = glob("cdn/products/".$product->product_number."/*.{jpg,png,gif,jpeg}", GLOB_BRACE);
            foreach ($files as $file) {
                // dd($file);
                    @unlink(public_path($file));
            }
            @rmdir($dirPath);
        // }
        $product->OrderItem()->delete();
        $product->delete();
        return 'success';
    }
    public function deleteArray(Request $request)
    {
        if ($request->has('ids') && is_array($request->ids) && sizeof($request->ids) > 0 ) {
            foreach ($request->ids as $id) {
                $pro = Product::find($id);
                if($pro)
                $this->destroy($pro);
            }
        }
        return response()->json([
            'message' => "تم الحذف بنجاح",
            'code' => 200
        ]);
    }
    public function updateArray(Request $request)
    {
        // return $request->all();
        $data = $request->only(['mission_id', 'category_id', 'branch_id', 'active']);
        if (trim($data['mission_id']) == '') unset($data['mission_id']);
        if (trim($data['category_id']) == '') unset($data['category_id']);
        if (trim($data['branch_id']) == '') unset($data['branch_id']);
        if (!isset($data['active']) || trim($data['active']) == '') $data['active'] = 0;
        if ($request->has('ids') && $request->ids != '' ) {
            $ids = explode(',', $request->ids);
            Product::whereIn('id', $ids)->update($data);
        dd($ids);
        }
        return response()->json([
            'message' => "تم التعديل بنجاح",
            'code' => 200
        ]);
    }
    public function Import(Request $request)
    {

        if ($request->hasFile('excel')) {
            $file = uploadFiless($request->file('excel'));
            $excelfile = public_path('/cdn/'.$file);
            Excel::import(new ProductImport, $excelfile);
        }

            return redirect()->back()->with('success', 'All good!');

    }
}
