@extends('admin.pdf.pdfmaster')
@section('content')
<h1>تقرير مدينة : {{$city->name}}</h1>
<h4>المعدات</h4>
<table cellpadding="10">
    <thead>
        <tr bgcolor="#d5f0f5">
            <th>اسم المعده </th>
            <th> الموديل</th>
            <th>نوع المعده </th>
            <th>المهمه </th>
            <th>السعر </th>
            <th>الكميه </th>
            <th>الفرع </th>
            <th>الطراز </th>
            <th>النوع</th>
        </tr>
    </thead>
    <tbody>
        {{--  /////////////  --}}
        @foreach($city->Products()->get() as $item)
        <tr>
            <td> {{ $item->title ?? '' }} </td>
            <td> {{ $item->Models->name_ar ?? '' }} </td>
            <td> {{ $item->Category->name_ar ?? '' }} </td>
            <td> {{ $item->Mission->name_ar ?? '' }} </td>
            <td> {{ $item->price ?? '' }} </td>
            <td> {{ $item->quantity ?? '' }} </td>
            <td> {{ $item->Branch->name_ar ?? '' }} </td>
            <td> {{ $item->verision ?? '' }} </td>
            <td> {{ ($item->type == 'rent') ? 'للايجار' : 'للبيع' }} </td>
        </tr>
        @endforeach
    </tbody>
</table>
<h4>الطلبات</h4>
<table cellpadding="10">
    <thead>
        <tr bgcolor="#d5f0f5">
				<th>رقم الطلب  </th>
				<th>اسم  العميل </th>
				<th> رقم الجوال </th>
				<th> السعر الكلى </th>
			   <th>تاريخ الطلب</th>
				<th>الحالة </th>
				<th>نوع الطلب </th>
			</tr>
		</thead>

		<tbody>
			@foreach(\App\Models\Order::whereHas('User', function($q) use($city) {$q->where('city_id', $city->id);})->get() as $item)
			<tr>
				<td> {{$item->id}} </td>
				<td> {{ $item->User->name ?? '' }} </td>
				<td> {{ $item->User->phone ?? '' }} </td>
				<td> {{ $item->total_price ?? '' }} </td>
				
				<td> {{ $item->created_at ?? '' }}  </td>
				<td> {{__('words.'.$item->status)}} </td>
				<td> {{__('words.'.$item->OrderItem()->first()->Product->type ?? '')}} </td>
			</tr>
			@endforeach

		</tbody>
</table>
@endsection
