<?php
namespace App\Traits\Api;

use Illuminate\Http\Request;
use App\Models\Order;
use App\Models\User;
use App\Models\Driver;
use Carbon\Carbon;
use Auth;
use DB;
use App\Http\Controllers\Api\FCMController;
use App\Models\Admin;
use App\Notifications\AdminNotification;

trait OrderOperations
{
    /**
     * Register a New .
     *
     * @param $request
     * @return \App\
     */
    public function register ($request, $user )
    {
        DB::beginTransaction();
        $data = $request->all();
        $order  = $user->Order()->create($data);
        if ($request->hasFile('images')) {
            foreach ($request->images as $image) {
                $image = uploadImage($image);
                $order->OrderImage()->create(['image' => $image]);
            } 
        }
        // send notification to admin start
        $admin = Admin::first();
        $admin->notify(new AdminNotification('طلب جديد #' . $order->id , route('orders.show', $order->id)));
        // send notification to admin end
        DB::commit();
        return $order;
    }


    /**
     * Update Record
     * @param $truck
     * @param $request
     */
    public function UpdateOrderStatus(Order $order,$request)
    {
        $order->update(['status' => $request->get('status')]);
        return $order;
    }
    
    public function SendOrderToDriver($order_id)
    {
        $Order = Order::find($order_id);
        $internal_drivers = Driver::where('type', '<>', 'not_employee')
                                    ->where('is_online', '1')
                                    ->doesnthave('Order', 'or', function($q){
                                        $q->where('status', 'finished');
                                    })
                                    ->get();
        $external_drivers = Driver::where('type', '=', 'not_employee')
                                    ->where('is_online', '1')
                                    ->doesntHave('Order', 'or', function($q){
                                        $q->where('status', 'finished');
                                    })
                                    ->get();
        // send notification to drivers start
        if ($internal_drivers->count() > 0) {
            foreach ($internal_drivers as $driver) {
                // send notification
                
                if( $driver->lang == 'ar')
                {
                    $title = "تم ارسال طلب لك رقم #". $Order->id;
                    $content = "تم ارسال طلب لك رقم #". $Order->id ;

                }else{
                    $title = "You have new Order number #".$Order->id;
                    $content = "You have new Order number #".$Order->id ;
                }
                $type = "new_order";
                
                $title_ar = "تم ارسال طلب لك رقم #".$Order->id;
                $title_en = "You have new Order number #".$Order->id;
                $content_ar = "تم ارسال طلب لك رقم #".$Order->id ;
                $content_en = "You have new Order number #".$Order->id ;
                $activity = "new_order";
                $data2 = [
                    'order' => $Order,
                    'title_ar' => $title_ar,
                    'title_en' => $title_en,
                    'content_ar' => $content_ar,
                    'content_en' => $content_en,
                    'type' => $type,
                ];
                $notifiable = $driver;
                $token = $notifiable->PlayerId()->pluck('player_id')->toArray();
                FCMController::Push($title, $content,$token,$data2);
                // send notification end
            }
        } else {
            foreach ($external_drivers as $driver) {
                // send notification
                
                if( $driver->lang == 'ar')
                {
                    $title = "تم ارسال طلب لك رقم #". $Order->id;
                    $content = "تم ارسال طلب لك رقم #". $Order->id ;

                }else{
                    $title = "You have new Order number #".$Order->id;
                    $content = "You have new Order number #".$Order->id ;
                }
                $type = "new_order";
                
                $title_ar = "تم ارسال طلب لك رقم #".$Order->id;
                $title_en = "You have new Order number #".$Order->id;
                $content_ar = "تم ارسال طلب لك رقم #".$Order->id ;
                $content_en = "You have new Order number #".$Order->id ;
                $activity = "new_order";
                $data2 = [
                    'order' => $Order,
                    'title_ar' => $title_ar,
                    'title_en' => $title_en,
                    'content_ar' => $content_ar,
                    'content_en' => $content_en,
                    'type' => $type,
                ];
                $notifiable = $driver;
                $token = $notifiable->PlayerId()->pluck('player_id')->toArray();
                FCMController::Push($title, $content,$token,$data2);
                // send notification end
            }
        }
        
        // send notification to drivers end
        return $internal_drivers;
    }

}