<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

class OrderItem extends Model
{
    protected $table='order_items';
    protected $fillable = [
        'order_id', 'product_id','quantity', 'total_price' , 'time' , 'price', 'product_type', 'rent_type', 'gasoline_cost', 'move_cost',
        'housing_cost', 'city_id', 'latitude', 'longitude', 'months', 'date_from', 'date_to'
    ];
    protected $hidden = [
        'date_from', 'date_to', 'time_from', 'time_to',
    ];
    protected $appends = ['days', 'hours', 'from_hour', 'to_hour'];
    protected $casts = [
        'created_at' => 'datetime:d/m/Y',
        'updated_at' => 'datetime:d/m/Y',
    ];

    public function Order()
    {
        return $this->belongsTo(Order::class,'order_id');
    }

    public function OrderItemDay()
    {
        return $this->Hasmany(OrderItemDay::class,'order_item_id');
    }
    public function Product()
    {
        return $this->belongsTo(Product::class,'product_id');
    }
    public function City()
    {
        return $this->belongsTo(City::class,'city_id');
    }

    public function getDaysAttribute()
    {
        return $this->OrderItemDay()->count();
    }
    public function getHoursAttribute()
    {
        $hours = null;
        if ($this->rent_type == 'hour' && $this->OrderItemDay()->first()) {
            $hours = Carbon::parse($this->OrderItemDay()->first()->time_from)->diff(Carbon::parse($this->time_to))->format('%h:%I');
        }
        return $hours;
    }
    public function getFromHourAttribute()
    {
        $res = null;
        if ($this->rent_type == 'hour' && $this->OrderItemDay()->first()) {
            $res = $this->OrderItemDay()->first()->time_from;
        }
        return $res;
    }
    public function getToHourAttribute()
    {
        $res = null;
        if ($this->rent_type == 'hour' && $this->OrderItemDay()->first()) {
            $res = $this->OrderItemDay()->first()->time_to;
        }
        return $res;
    }
}
