<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Coupon;
use App\Models\Product;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;

class OCartController extends Controller
{
    public function addToCart(Request $request)
    {
        $user = auth('api')->user();
        // $city_id = $user->city_id;
        $city_id = $request->city_id;
        if ($request->has('empty') && $request->empty == '1') {
            $user->Cart()->delete();
        }
        $data = $request->except(['gasoline_cost', 'housing_cost', 'move_cost']);
        // check product type
        $product = Product::find($request->get('product_id'));
        if (!$product) {
            return Response()->json([
                'data'          => new \stdClass,
                'errors'        => [trans('words.product not found')],
                'message'       => trans('words.product not found'),
                'code'          => getMsgCode('notFound'),
            ]);
        }
        if ($user->Cart()->where('product_type', '<>', $product->type)->count() > 0 ) {
            return Response()->json([
                'data'          => new \stdClass,
                'errors'        => [trans('words.different types not allowed in cart.')],
                'message'       => trans('words.different types not allowed in cart.'),
                'code'          => getMsgCode('somethingWrong'),
            ]);
        }
        DB::beginTransaction();
        // check product exist
        if ( $user->Cart()->where('product_id', $product->id)->first() ) {
            $item = $user->Cart()->where('product_id', $product->id)->first();
            $data['product_type'] = $product->type;
            if($product->quantity && ($item->quantity + $request->quantity) > $product->quantity)
            {
                return Response()->json([
                    'data'          => new \stdClass,
                    'errors'        => [trans('words.quantity not available')],
                    'message'       => trans('words.quantity not available'),
                    'code'          => getMsgCode('somethingWrong'),
                ]);
            }
            $data['quantity'] = $item->quantity + $request->quantity;
            // if ($product->type == 'rent') {
            //     if ($request->has('gasoline_cost') && $request->gasoline_cost == '1') {
            //         $data['gasoline_cost'] = $product->gasoline * (float)getSettingValue('gasoline_cost');
            //     }
            //     if ($request->has('housing_cost') && $request->housing_cost == '1') {
            //         $data['housing_cost'] = (float)getSettingValue('housing_cost');
            //     }
            //     if ($request->has('move_cost') && $request->move_cost == '1' && $city_id && $product->ProductCity()->where('city_id', $city_id)->first()) {
            //         $data['move_cost'] = $product->ProductCity()->where('city_id', $city_id)->first()->cost;
            //     }
            // }
            $item->update($data);
        }else{
            $data['product_type'] = $product->type;
            // if ($product->gasoline && $product->type == 'rent') {
            //     $data['gasoline_cost'] = $product->gasoline * (float)getSettingValue('gasoline_cost');
            // }
            // if ($product->type == 'rent') {
            //     if ($request->has('gasoline_cost') && $request->gasoline_cost == '1') {
            //         $data['gasoline_cost'] = $product->gasoline * (float)getSettingValue('gasoline_cost');
            //     }
            //     if ($request->has('housing_cost') && $request->housing_cost == '1') {
            //         $data['housing_cost'] = (float)getSettingValue('housing_cost');
            //     }
            //     if ($request->has('move_cost') && $request->move_cost == '1' && $city_id && $product->ProductCity()->where('city_id', $city_id)->first()) {
            //         $data['move_cost'] = $product->ProductCity()->where('city_id', $city_id)->first()->cost;
            //     }
            // }
            if($product->quantity && $request->quantity > $product->quantity)
            {
                return Response()->json([
                    'data'          => new \stdClass,
                    'errors'        => [trans('words.quantity not available')],
                    'message'       => trans('words.quantity not available'),
                    'code'          => getMsgCode('somethingWrong'),
                ]);
            }
            $item = $user->Cart()->create($data);
        }
        $item->CartItemDay()->delete();
        if ($data['product_type'] == 'rent') {
            if ($city_id && $product->ProductCity()->where('city_id', $city_id)->first() ) {
                $move_cost = $product->ProductCity()->where('city_id', $city_id)->first()->cost; 
            }else{
                $move_cost = 0;
            }
            $item->update(['move_cost' => $move_cost]);
            // array of days start
            if ($data['rent_type'] == 'day' && isset( $data['rent_days'] ) && is_array(  $data['rent_days']  ) ) {
                foreach ($data['rent_days'] as $day) {
                    $item->CartItemDay()->create( ['day_date' => $day] );
                }
                if ($request->has('gasoline_cost') && $request->gasoline_cost == '1') {
                    $data['gasoline_cost'] = sizeof($data['rent_days']) * $product->gasoline * (float)getSettingValue('gasoline_cost');
                }
                if ($request->has('housing_cost') && $request->housing_cost == '1') {
                    if (sizeof($data['rent_days']) > 1) {
                        
                        $data['housing_cost'] = sizeof($data['rent_days']) *(float)getSettingValue('housing_cost');
                    }
                }
                if ($request->has('move_cost') && $request->move_cost == '1' && $city_id && $product->ProductCity()->where('city_id', $city_id)->first()) {
                    $data['move_cost'] = $product->ProductCity()->where('city_id', $city_id)->first()->cost * $data['quantity'];
                }
                // $pro_price = sizeof($data['rent_days']) * $product->daily_price;  
            }elseif ($data['rent_type'] == 'time' && isset( $data['rent_day_time'] ) && is_array(  $data['rent_day_time']  ) ) {
                    $item->CartItemDay()->create( $data['rent_day_time'] );
                    $from = Carbon::createFromFormat('Y-m-d H:s:i', $data['rent_day_time']['day_date'] . ' ' . $data['rent_day_time']['time_from']);
                    $to = Carbon::createFromFormat('Y-m-d H:s:i', $data['rent_day_time']['day_date'] . ' ' . $data['rent_day_time']['time_to']);
                    $diff_in_hours = $to->diffInHours($from);
                    if ($request->has('gasoline_cost') && $request->gasoline_cost == '1') {
                        $data['gasoline_cost'] =  $product->gasoline * (float)getSettingValue('gasoline_cost');
                    }
                    if ($request->has('move_cost') && $request->move_cost == '1' && $city_id && $product->ProductCity()->where('city_id', $city_id)->first()) {
                        $data['move_cost'] = $product->ProductCity()->where('city_id', $city_id)->first()->cost * $data['quantity'];
                    }
                $pro_price = $diff_in_hours * $product->hour_price; 
            }elseif ($data['rent_type'] == 'month' && isset( $data['start_date'] ) && isset( $data['months'] ) ) {
                $app = new AppInfoController;
                foreach ($app->getHolidays( $data['start_date'], Carbon::parse($data['start_date'])->addMonths($data['months']), $data['months'])['res'] as $day) {
                    $item->CartItemDay()->create( ['day_date' => $day] );
                }
                if ($request->has('gasoline_cost') && $request->gasoline_cost == '1') {
                    $data['gasoline_cost'] = sizeof($app->getHolidays( $data['start_date'], Carbon::parse($data['start_date'])->addMonths($data['months']), $data['months'])['res']) * $product->gasoline * (float)getSettingValue('gasoline_cost');
                }
                if ($request->has('housing_cost') && $request->housing_cost == '1') {
                    if (sizeof($app->getHolidays( $data['start_date'], Carbon::parse($data['start_date'])->addMonths($data['months']), $data['months'])['res']) > 1) {
                        
                        $data['housing_cost'] = sizeof($app->getHolidays( $data['start_date'], Carbon::parse($data['start_date'])->addMonths($data['months']), $data['months'])['res']) *(float)getSettingValue('housing_cost');
                    }
                }
                if ($request->has('move_cost') && $request->move_cost == '1' && $city_id && $product->ProductCity()->where('city_id', $city_id)->first()) {
                    $data['move_cost'] = $product->ProductCity()->where('city_id', $city_id)->first()->cost * $data['quantity'];
                }
            }
            $item->update(['gasoline_cost' => @$data['gasoline_cost'], 'housing_cost' => @$data['housing_cost'], 'move_cost' => @$data['move_cost'] ]);
        }
        DB::commit();
        return $this->viewCart($request);
        /*$move_cost = 0;//$user->Cart()->sum('move_cost');
        $gasoline_cost = $user->Cart()->sum('gasoline_cost');
        $housing_cost = $user->Cart()->sum('housing_cost');
        $cart = $user->Cart()->with('Product')->get();
        $total_price = 0;//$pro_price;
        // foreach ($cart as $item) {
        //     $total_price += $item->quantity * $item->Product->price;
        // }
        foreach ($cart as $item) {
            $product = $item->Product()->first();
            if ($product) {
                
                if ($item->product_type == 'rent') {
                    // 
                    if ($item->rent_type == 'day') {
                        $total_price += $item->CartItemDay()->count() * $product->daily_price;  
                    } else if ($item->rent_type == 'month') {
                        $total_price += $item->CartItemDay()->count() * $product->daily_price;  
                    } else {
                        if ($item->CartItemDay()->first()) {
                            
                            $from = Carbon::createFromFormat('Y-m-d H:s:i', $item->CartItemDay()->first()->day_date . ' ' . $item->CartItemDay()->first()->time_from);
                            $to = Carbon::createFromFormat('Y-m-d H:s:i', $item->CartItemDay()->first()->day_date . ' ' . $item->CartItemDay()->first()->time_to);
                            $diff_in_hours = $to->diffInHours($from);
                            $total_price += $diff_in_hours * $product->hour_price; 
                        }
                    }
                if ($city_id && $product->ProductCity()->where('city_id', $city_id)->first()) {
                    // $move_cost2 = $product->ProductCity()->where('city_id', $city_id)->first()->cost; 
                    $move_cost2 = $item->move_cost; 
                }else{
                    $move_cost2 = 0;
                }
                $move_cost += $move_cost2;
                    
                }else{
                    $total_price += $item->quantity * $item->Product->price;
                }
            }
        }
        return Response()->json([
            'data'          => [
                'cart'  => $cart,
                'sub_total_price'  => $total_price,
                'total_price'  => $total_price + $move_cost + $gasoline_cost + (round((float)getSettingValue('tax'),2) / 100 * $total_price),
                'move_cost'  => $move_cost,
                'vat'  => round((float)getSettingValue('tax'),2),
                'vat_cost'  => round((float)getSettingValue('tax'),2) / 100 * $total_price,
                'gasoline_cost'  => round($gasoline_cost,2),
                'housing_cost'  => round($housing_cost,2),
            ],
            'message'       => 'success',
            'code'          => getMsgCode('success'),
        ]);*/
    }
    public function viewCart(Request $request)
    {
        $user = auth('api')->user();
        $city_id = $user->city_id;
        $move_cost = 0;//$user->Cart()->sum('move_cost');
        $gasoline_cost = $user->Cart()->sum('gasoline_cost');
        $housing_cost = $user->Cart()->sum('housing_cost');
        $cart = $user->Cart()->with('Product')->get();
        $total_price = 0;
        foreach ($cart as $item) {
            $product = $item->Product()->first();
            if ($product) {
                
                if ($item->product_type == 'rent') {
                    // 
                    if ($item->rent_type == 'day') {
                        $total_price += $item->CartItemDay()->count() * $product->daily_price;  
                    } else if ($item->rent_type == 'month') {
                        $total_price += $item->CartItemDay()->count() * $product->daily_price;  
                    } else {
                        if ($item->CartItemDay()->first()) {
                            
                            $from = Carbon::createFromFormat('Y-m-d H:s:i', $item->CartItemDay()->first()->day_date . ' ' . $item->CartItemDay()->first()->time_from);
                            $to = Carbon::createFromFormat('Y-m-d H:s:i', $item->CartItemDay()->first()->day_date . ' ' . $item->CartItemDay()->first()->time_to);
                            $diff_in_hours = $to->diffInHours($from);
                            $total_price += $diff_in_hours * $product->hour_price; 
                        }
                    }
                if ($city_id && $product->ProductCity()->where('city_id', $city_id)->first() ) {
                    $move_cost2 = $product->ProductCity()->where('city_id', $city_id)->first()->cost; 
                }else{
                    $move_cost2 = 0;
                }
                $move_cost += $move_cost2;
                    
                }else{
                    $total_price += $item->quantity * $item->Product->price;
                }
            }
        }
        if ($user->Cart()->first()) {
            $type = $user->Cart()->first()->product_type;
        } else {
            $type = null;
        }
        
        return Response()->json([
            'data'          => [
                'cart'  => $cart,
                'sub_total_price'  => $total_price,
                'total_price'  => $total_price + $move_cost + $gasoline_cost + (round((float)getSettingValue('tax'),2) / 100 * $total_price),
                'move_cost'  => $move_cost,
                'vat'  => round((float)getSettingValue('tax'),2),
                'vat_cost'  => round((float)getSettingValue('tax'),2) / 100 * $total_price,
                'gasoline_cost'  => round($gasoline_cost,2),
                'housing_cost'  => round($housing_cost,2),
                'type'  => $type,
            ],
            'message'       => 'success',
            'code'          => getMsgCode('success'),
        ]);
    }
    public function removeFromCart(Request $request)
    {
        $user = auth('api')->user();
        $city_id = $user->city_id;
        $product = Product::find($request->get('product_id'));
        if (!$product) {
            return Response()->json([
                'data'          => new \stdClass,
                'errors'        => [trans('words.product not found')],
                'message'       => trans('words.product not found'),
                'code'          => getMsgCode('notFound'),
            ]);
        }
        $user->Cart()->where('product_id', $product->id)->delete();
        return $this->viewCart($request);
        /*
        $move_cost = $user->Cart()->sum('move_cost');
        $gasoline_cost = $user->Cart()->sum('gasoline_cost');
        $housing_cost = $user->Cart()->sum('housing_cost');
        $cart = $user->Cart()->with('Product')->get();
        $total_price = 0;
        foreach ($cart as $item) {
            $total_price += $item->quantity * $item->Product->price;
        }
        return Response()->json([
            'data'          => [
                'cart'  => $cart,
                'sub_total_price'  => $total_price,
                'total_price'  => $total_price + $move_cost + $gasoline_cost + (round((float)getSettingValue('tax'),2) / 100 * $total_price),
                'move_cost'  => $move_cost,
                'vat'  => round((float)getSettingValue('tax'),2),
                'vat_cost'  => round((float)getSettingValue('tax'),2) / 100 * $total_price,
                'gasoline_cost'  => round($gasoline_cost,2),
                'housing_cost'  => round($housing_cost,2),
            ],
            'message'       => 'success',
            'code'          => getMsgCode('success'),
        ]);*/
    }
    public function updateCartItem(Request $request, $id)
    {
        $user = auth('api')->user();
        $data = $request->all();
        $item = $user->Cart()->where('id', $id)->first();
        $product = $item->Product()->first();
        if($product->quantity && $request->quantity > $product->quantity)
            {
                return Response()->json([
                    'data'          => new \stdClass,
                    'errors'        => [trans('words.quantity not available')],
                    'message'       => trans('words.quantity not available'),
                    'code'          => getMsgCode('somethingWrong'),
                ]);
            }
        $user->Cart()->where('id', $id)->update($data);
        return $this->viewCart($request);
    }
    public function checkCoupon(Request $request)
    {
        
        $user = auth('api')->user();
        $city_id = $user->city_id;
        $move_cost = 0;//$user->Cart()->sum('move_cost');
        $gasoline_cost = $user->Cart()->sum('gasoline_cost');
        $housing_cost = $user->Cart()->sum('housing_cost');
        $cart = $user->Cart()->with('Product')->get();
        $total_price = 0;
        foreach ($cart as $item) {
            $product = $item->Product()->first();
            if ($product) {
                
                if ($item->product_type == 'rent') {
                    // 
                    if ($item->rent_type == 'day') {
                        $total_price += $item->CartItemDay()->count() * $product->daily_price;  
                    } else {
                        if ($item->CartItemDay()->first()) {
                            
                            $from = Carbon::createFromFormat('Y-m-d H:s:i', $item->CartItemDay()->first()->day_date . ' ' . $item->CartItemDay()->first()->time_from);
                            $to = Carbon::createFromFormat('Y-m-d H:s:i', $item->CartItemDay()->first()->day_date . ' ' . $item->CartItemDay()->first()->time_to);
                            $diff_in_hours = $to->diffInHours($from);
                            $total_price += $diff_in_hours * $product->hour_price; 
                        }
                    }
                if ($city_id && $product->ProductCity()->where('city_id', $city_id)->first() ) {
                    $move_cost2 = $product->ProductCity()->where('city_id', $city_id)->first()->cost; 
                }else{
                    $move_cost2 = 0;
                }
                $move_cost += $move_cost2;
                    
                }else{
                    $total_price += $item->quantity * $item->Product->price;
                }
            }
        }
        if ($user->Cart()->first()) {
            $type = $user->Cart()->first()->product_type;
        } else {
            $type = null;
        }
        if ($request->has('coupon') && $request->get('coupon') != '') {
            $coupon = Coupon::where('coupon', $request->get('coupon'))->where('active', '1')->first();
            if ($coupon) {
                if ($coupon->Order()->count() >= $coupon->benefits) {
                    $msg = 'coupon benefits ended';
                }else{
                    $percent = $coupon->amount;
                    // $discount = $total_price / 100 * $percent;
                    return Response()->json([
                        'data'          => [
                            'coupon'  => $request->get('coupon'),
                            'coupon_discount_percent'  => $percent,
                            'coupon_discount_value'  => ($total_price / 100 * $percent),
                            'cart'  => $cart,
                            'sub_total_price'  => $total_price ,
                            'total_price'  => ($total_price / 100 * (100 - $percent)) + $move_cost + $gasoline_cost + (round((float)getSettingValue('tax'),2) / 100 * ($total_price / 100 * (100 - $percent))),
                            'move_cost'  => $move_cost,
                            'vat'  => round((float)getSettingValue('tax'),2),
                            'vat_cost'  => round((float)getSettingValue('tax'),2) / 100 * ($total_price / 100 * (100 - $percent)),
                            'gasoline_cost'  => round($gasoline_cost,2),
                            'housing_cost'  => round($housing_cost,2),
                            'type'  => $type,
                        ],
                        'message'       => 'success',
                        'code'          => getMsgCode('success'),
                    ]);
                }
            } else {
                $msg = 'coupon not found';
            }
        }

        // 
        return Response()->json([
            'data'          => [
                'cart'  => $cart,
                'sub_total_price'  => $total_price,
                'total_price'  => $total_price + $move_cost + $gasoline_cost + (round((float)getSettingValue('tax'),2) / 100 * $total_price),
                'move_cost'  => $move_cost,
                'vat'  => round((float)getSettingValue('tax'),2),
                'vat_cost'  => round((float)getSettingValue('tax'),2) / 100 * $total_price,
                'gasoline_cost'  => round($gasoline_cost,2),
                'housing_cost'  => round($housing_cost,2),
                'type'  => $type,
            ],
            'message'       => $msg,
            'code'          => 500,
        ]);
    }


    public function costs(Request $request)
    {
        // $city_id = $user->city_id;
        $data = $request->all();
        $city_id = $request->city_id;
        // check product type
        $product = Product::find($request->get('product_id'));
        if (!$product) {
            return Response()->json([
                'data'          => new \stdClass,
                'errors'        => [trans('words.product not found')],
                'message'       => trans('words.product not found'),
                'code'          => getMsgCode('notFound'),
            ]);
        }
        $gasoline_cost = 0;
        $housing_cost = 0;
        DB::beginTransaction();
        // check product exist
        if ($product->type == 'rent') {
            $gasoline_cost = $product->gasoline * (float)getSettingValue('gasoline_cost');
            
            
            $housing_cost = (float)getSettingValue('housing_cost');
            
            // array of days start
            if ($data['rent_type'] == 'day' && isset( $data['rent_days'] ) && is_array(  $data['rent_days']  ) ) {
                $housing_cost = sizeof($data['rent_days']) * $housing_cost;  
                $gasoline_cost = sizeof($data['rent_days']) * $gasoline_cost ;  
            }elseif ($data['rent_type'] == 'month' && isset( $data['start_date'] ) && isset( $data['months'] ) ) {
                $app = new AppInfoController;
                 
                $housing_cost = sizeof($app->getHolidays( $data['start_date'], Carbon::parse($data['start_date'])->addMonths($data['months']), $data['months'])['res']) * $housing_cost;  
                $gasoline_cost = sizeof($app->getHolidays( $data['start_date'], Carbon::parse($data['start_date'])->addMonths($data['months']), $data['months'])['res']) * $gasoline_cost * 24; 

            }elseif ($data['rent_type'] == 'time' && isset( $data['rent_day_time'] ) && is_array(  $data['rent_day_time']  ) ) {
                    $from = Carbon::createFromFormat('Y-m-d H:s:i', $data['rent_day_time']['day_date'] . ' ' . $data['rent_day_time']['time_from']);
                    $to = Carbon::createFromFormat('Y-m-d H:s:i', $data['rent_day_time']['day_date'] . ' ' . $data['rent_day_time']['time_to']);
                    $diff_in_hours = $to->diffInHours($from);
                $gasoline_cost = $diff_in_hours * $gasoline_cost; 
            }
        }
        DB::commit();
        return Response()->json([
            'data'          => [
                'gasoline_cost'  => round($gasoline_cost,2),
                'housing_cost'  => round($housing_cost,2),
            ],
            'message'       => 'success',
            'code'          => getMsgCode('success'),
        ]);
    }
}
