<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\Admin\UpdateTripRequest;
use App\Http\Requests\Admin\StoreTripRequest;
use App\Http\Controllers\Controller;
use App\Traits\Admin\TripOperations;
use Illuminate\Http\Request;
use App\Models\Admin;
use App\Models\Trip;
use Auth;

class TripController extends Controller
{
    use TripOperations;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function __construct()
    {
        $this->middleware('Permission:trip_show'    , ['only' => 'index', 'show']);
        $this->middleware('Permission:trip_add'     , ['only' => 'create', 'store']);
        $this->middleware('Permission:trip_edit'    , ['only' => 'edit', 'update']);
        $this->middleware('Permission:trip_delete'  , ['only' => 'destroy']);
    }
    public function index()
    {
        $all = Trip::latest()->get();
        $trips = Trip::latest()->get();
        $title = 'الرحلات';
        return view('admin.trips.index', compact('trips', 'title'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $title = 'اضافة رحلة';
        return view('admin.trips.add', compact('title'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreTripRequest $request)
    {
        $this->register($request);
        return redirect()->back()->with('success', 'data added successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Trip $trip)
    {
        $title = 'عرض رحلة';
        return view('admin.trips.show', compact('trip', 'title'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $trip = Trip::find($id);
        $title = 'تعديل رحلة';
        return view('admin.trips.edit', compact('trip', 'title'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateTripRequest $request,  $id)
    {
        $trip = Trip::find($id);
        $this->UpdateRecords($trip, $request);
        return redirect(route('trips.index'))->with('success', 'data added successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Trip $trip)
    {
        if ($trip->image) {
            @unlink(public_path('/cdn/'.$trip->image));
        }
        $trip->delete();
        return 'success';
    }
}
