<?php
namespace App\Traits\Admin;

use App\Http\Controllers\Api\FCMController;
use App\Notifications\GeneralNotification;
use Illuminate\Http\Request;
use App\Models\Product;
use App\Models\Driver;
use App\Models\PriceList;
use DB;
use Carbon\Carbon;
use App\Models\Admin;
use App\Notifications\AdminNotification;

trait ProductOperations
{


    /**
     * Register a New .
     *
     * @param $request
     * @return \App\
     */
    public function register ($request)
    {
        $data = $request->all();
        // $data['category_id'] = 1;;
        DB::beginTransaction();
        $Product = Product::create($data);
        $path = 'products/'.$request->product_number.'/';
        // dd($path);
        if ($request->hasFile('images') ) {
            foreach ($request->file('images') as $image) {
                $data2['name'] = uploadImage($image, $path);
                $Product->Files()->create($data2);
            }
        }
        if ($request->has('features') ) {
            foreach ($request->get('features') as $it) {
                // dd($it);
                if (isset($it['city']) && !in_array($it['city'], [null, ''])) {
                    $it['city_id'] = $it['city'];
                    $Product->ProductCity()->create($it);

                }
            }
        }
        DB::commit();
        // dd($data);
        return $Product;
    }


    /**
     * Update Record
     * @param $truck
     * @param $request
     */
    public function UpdateRecords(Product $Product,$request)
    {
        $data = $request->all();

        $path = 'products/'.$request->product_number.'/';
        // dd($path);
        if ($request->hasFile('images') ) {
            foreach ($request->file('images') as $image) {
                $data2['name'] = uploadImage($image, $path);
                $Product->Files()->create($data2);
            }
        }
        if ($request->has('active') && $data['active'] == '1') {
            $data['active'] = '1';
        }else{
            $data['active'] = '0';

        }
        if ($request->has('features') ) {
            foreach ($request->get('features') as $it) {
                // dd($it);
                if (isset($it['city']) && !in_array($it['city'], [null, ''])) {
                    $it['city_id'] = $it['city'];
                    $Product->ProductCity()->create($it);

                }
            }
        }
        $Product->update($data);
        return $Product;
    }
    /**
     * delete Record
     * @param $truck
     * @param $request
     */
    public function DeleteRecord($id)
    {
        //
    }
}
