<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\Transaction;
use App\Traits\Api\TransactionOperations;
use Auth;
use App\Models\Admin;
use App\Models\Order;
use App\Notifications\AdminNotification;

class TransactionController extends Controller
{
	use TransactionOperations;
    
    public function PrepareCheckout(Request $request) {
        $user = Auth::guard('api')->user();
        $price = $request->get('price');
        $url = "https://test.oppwa.com/v1/checkouts";
        $data = "entityId=8ac7a4ca70bf29f40170c4f79f740be3" .
                    "&amount=".$price .
                    "&currency=SAR" .
                    "&paymentType=DB".
                    "&testMode=EXTERNAL" .
                    "&merchantTransactionId=".time() .
                    "&customer.email=". $user->email .
                    "&notificationUrl=http://www.reamapp.com/getstatus";
                     $order_data = '';

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                       'Authorization:Bearer OGFjN2E0Y2E3MGJmMjlmNDAxNzBjNGY3MTFjNzBiZGV8eDdwUXlDN0hkOQ=='));
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);// this should be set to true in production
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $responseData = curl_exec($ch);
    	if(curl_errno($ch)) {
    		return curl_error($ch);
    	}
    	curl_close($ch);
    // 	return $responseData;
    	return Response()->json([
                'data' => [
                    'transaction' => json_decode($responseData)
                ],
                'message' => 'success',
                'code' => getMsgCode('success')
        ]);
    }
    
    public function PaymentRequest(Request $request) {
    	$user = Auth::guard('api')->user();
    	$id = $request->get('checkout_id');
        $url = "https://test.oppwa.com/v1/checkouts/".$id."/payment";
        $url .= "?entityId=8ac7a4ca70bf29f40170c4f79f740be3";

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                       'Authorization:Bearer OGFjN2E0Y2E3MGJmMjlmNDAxNzBjNGY3MTFjNzBiZGV8eDdwUXlDN0hkOQ=='));
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);// this should be set to true in production
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $responseData = curl_exec($ch);
    	if(curl_errno($ch)) {
    		return curl_error($ch);
    	}
    	curl_close($ch);
    	$user = Auth::guard('api')->user();
    // 	
        $obj = json_decode($responseData);

        $code= $obj->result->code;
  
		if (preg_match('/^(000\.000\.|000\.100\.1|000\.[36])/', $code)
                || preg_match('/^(000\.400\.0|000\.400\.100)/', $code)) {
                    $order = Order::find($request->get('order_id'));
                    // if ($order->transfer_type != 'branch_to_branch') {
                    //     $this->SendOrderToDriver($order->id);
                    // }
                    $order->update(['status' => 'confirmed']);
                    $data = [
                        "user_id" => $user->id,
                        "order_id" => $order->id,
                        "data" => json_encode($obj),
                    ];
                    return Response()->json([
                        'data' => [
                            'order' => $order
                        ],
                        'message' => 'success',
                        'code' => getMsgCode('success')
                ]);
            }else{
                $order = Order::find($request->get('order_id'));
                
                    $order->update(['status' => 'init']);
            }
            
        return Response()->json([
                'data' => [
                    'transaction' => json_decode($responseData)
                ],
                'message' => 'somethingWrong',
                'code' => getMsgCode('somethingWrong')
        ]);
    }
    
}
