<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Admin;
use App\Models\Payment;
use Auth;

class PaymentController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function __construct()
    {
        // $this->middleware('Permission:engPayment_show'    , ['only' => 'index', 'show']);
        // $this->middleware('Permission:engPayment_add'     , ['only' => 'create', 'store']);
        // $this->middleware('Permission:engPayment_edit'    , ['only' => 'edit', 'update']);
        // $this->middleware('Permission:engPayment_delete'  , ['only' => 'destroy']);
    }
    public function index()
    {
        $all = Payment::latest()->get();
        $payments = Payment::latest()->get();
        $incomes = Payment::where('payment_type', 'income')->latest()->paginate(20);
        $company_outcomes = Payment::where('payment_type', 'outcome')->where('taggable_type', 'App\Models\Company')->latest()->paginate(20);
        $school_outcomes = Payment::where('payment_type', 'outcome')->where('taggable_type', 'App\Models\School')->latest()->paginate(20);
        $bus_outcomes = Payment::where('payment_type', 'outcome')->where('taggable_type', 'App\Models\Bus')->latest()->paginate(20);
        $incomes = Payment::where('payment_type', 'income')->latest()->paginate(20);
        $title = 'الحركات المالية';
        return view('admin.payments.index', compact('payments', 'title', 'incomes', 'company_outcomes', 'school_outcomes', 'bus_outcomes'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Payment $payment)
    {
        $title = 'عرض العنصر';
        return view('admin.payments.show', compact('payment', 'title'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $payment = Payment::find($id);
        $title = 'تعديل العنصر';
        return view('admin.payments.edit', compact('payment', 'title'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $payment = Payment::find($id);
        $payment->update($request->all());
        return redirect()->back()->with('success', 'data added successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Payment $payment)
    {
        if ($payment->image) {
            @unlink(public_path('/cdn/'.$payment->image));
        }
        $payment->delete();
        return 'success';
    }
}
