<!DOCTYPE html>
<html lang="en" dir="rtl">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <meta name="description" content="A fully featured admin theme which can be used to build CRM, CMS, etc.">
        <meta name="author" content="Coderthemes">

        <!-- App Favicon -->
        <link rel="shortcut icon" href="{{asset('/adminto/assets/images/favicon.ico')}}">
        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@400;500;700&display=swap" rel="stylesheet">
        <link rel="stylesheet" href="/myCss.css">

        <!-- App title -->
        <title>لوحه التحكم | تسجيل الدخول</title>

        <!-- App CSS -->
        <link href="{{asset('/adminto/assets/css/bootstrap-rtl.min.css')}}" rel="stylesheet" type="text/css" />
        <link href="{{asset('/adminto/assets/css/core.css')}}" rel="stylesheet" type="text/css" />
        <link href="{{asset('/adminto/assets/css/components.css')}}" rel="stylesheet" type="text/css" />
        <link href="{{asset('/adminto/assets/css/icons.css')}}" rel="stylesheet" type="text/css" />
        <link href="{{asset('/adminto/assets/css/pages.css')}}" rel="stylesheet" type="text/css" />
        <link href="{{asset('/adminto/assets/css/menu.css')}}" rel="stylesheet" type="text/css" />
        <link href="{{asset('/adminto/assets/css/responsive.css')}}" rel="stylesheet" type="text/css" />

        <![endif]-->

        <script src="{{asset('/adminto/assets/js/modernizr.min.js')}}"></script>
        
    </head>
   
<body id="log-page" style="height: 100vh;">
    <div class="lay"></div>
    <div class=" cont coustm ">
        <div class="text-center logo-wr">
            <a href="#" class="logo text-center">
                <img class="" src="/logo.png">
            </a>
        </div>
        <form class="form-horizontal m-t-20" method="POST" action="">
            <h4 class=" text-center text-uppercase font-bold m-b-0">تسجيل الدخول</h4>
                <!-- alert session -->
    @if(session()->has('success'))
    <div class="demo-spacing-0">
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <div class="alert-body">
                {{session()->get('success')}}
            </div>
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    </div>
    @elseif(session()->has('error'))
    <div class="demo-spacing-0">
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <div class="alert-body">
                {{session()->get('error')}}
            </div>
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    </div>
    @elseif(session()->has('warning'))
    <div class="demo-spacing-0">
        <div class="alert alert-warning alert-dismissible fade show" role="alert">
            <div class="alert-body">
                {{session()->get('warning')}}
            </div>
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    </div>
    @endif
    @if ($errors->any())
    <div class="demo-spacing-0">
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <div class="alert-body">
                <ul>
                    @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    </div>
    @endif
            {{ csrf_field() }}
            <div class="form-group{{ $errors->has('email') ? ' has-error' : '' }} ">
                <div class="col-xs-12">
                <input id="email" type="email" class="form-control" name="email" placeholder="ادخل البريد الالكترونى" value="{{ old('email') }}" required autofocus>
                @if ($errors->has('email'))
                    <span class="help-block">
                                <strong>{{ $errors->first('email') }}</strong>
                            </span>
                @endif
            </div>
            </div>

            <div class="form-group{{ $errors->has('password') ? ' has-error' : '' }}">
                <div class="col-xs-12">
                <input id="password" type="password" class="form-control" name="password" placeholder="ادخل كلمه المرور" required>
                @if ($errors->has('password'))
                    <span class="help-block">
                                <strong>{{ $errors->first('password') }}</strong>
                            </span>
                @endif
            </div>
            </div>
            <div class="form-group ">
                <div class="col-xs-12">
                    <div class="checkbox checkbox-custom">
                        <input id="checkbox-signup" type="checkbox" name="remember" {{ old('remember') ? 'checked' : '' }}>
                        <label for="checkbox-signup">
                            تذكرني
                        </label>
                    </div>

                </div>
            </div>

            
            <div class="form-group text-center">
                <div class="col-xs-12">
                    <input class="form-control" type="submit" value="تسجيل دخول">
                    </input>
                </div>
            </div>

        </form>
    </div>



</body>
