<?php
namespace App\Traits\Admin;

use App\Mail\Api\UserVerify as UserVerifyMail;
use Illuminate\Http\Request;
use App\Models\DeliveryUser;
use App\Models\User;
use Mail;
use DB;

use App\Http\Controllers\Api\FCMController;

trait UserOperations
{
  

    /**
     * Register a New .
     *
     * @param $request
     * @return \App\
     */
    public function register ($request)
    {
        $data = $request->all();
        if ($request->hasFile('image')) {
            $data['image'] = uploadFile($request);
        }
        if ($request->hasFile('business_image')) {
            $data['business']['image'] = uploadImage($request->file('business_image'));
        }
        // return dd($data);
        // $data['id'] = User::max('id') + 1;
        DB::beginTransaction();
        $user = User::create($data);
        if ($request->has('vip') && $data['vip'] == '1') {
            $user->BusinessAccount()->create($data['business']);
        }
        DB::commit();
        return $user;
    }


    /**
     * Update Record
     * @param $truck
     * @param $request
     */
    public function UpdateRecords(User $user,$request)
    {
        $data = $request->all();
        if ($request->hasFile('image')) {
            @unlink(public_path('/cdn/'.$user->image));
            // 
            $data['image'] = uploadFile($request);
        }
        if ($request->hasFile('business_image')) {
            $data['business']['image'] = uploadImage($request->file('business_image'));
        }
        if ($request->has('password') && $data['password'] != '') {
            $data['password'] = bcrypt($data['password']);
        }else{
            unset($data['password']);
        }
        if ($request->has('vip') && $data['vip'] == '1') {
            if ($user->vip != '1') {
                if( $user->lang == 'ar')
                {
                    $title = "تم تفعيل حساب البزنس الخاص بك";
                    $content = "تم تفعيل حساب البزنس الخاص بك" ;

                }else{
                    $title = "Your VIP account activated";
                    $content = "Your VIP account activated" ;
                }
                $type = "vip_account";
                
                $title_ar = "تم تفعيل حساب البزنس الخاص بك";
                $title_en = "Your VIP account activated";
                $content_ar = "تم تفعيل حساب البزنس الخاص بك" ;
                $content_en = "Your VIP account activated" ;
                $activity = "vip_account";
                $data2 = [
                    'user' => $user,
                    'title_ar' => $title_ar,
                    'title_en' => $title_en,
                    'content_ar' => $content_ar,
                    'content_en' => $content_en,
                    'type' => $type,
                ];
                $notifiable = $user;
                $token = $notifiable->PlayerId()->pluck('player_id')->toArray();
                FCMController::Push($title, $content,$token,$data2, $activity);
            }
            if ($user->BusinessAccount()->first()) {
                $user->BusinessAccount()->update($data['business']);
            } else {
                // 
                $user->BusinessAccount()->create($data['business']);
            }
            
        }
        $user->update($data);
        return $user;
    }

    /**
     * Update Record
     * @param $truck
     * @param $request
     */
    public function StorOrUpdateCost(User $user,$request)
    {
        $data = $request->all();
        DeliveryUser::updateOrcreate(['user_id' => $user->id], $data);
        return $user;
    }
    /**
     * delete Record
     * @param $truck
     * @param $request
     */
    public function DeleteRecord($id)
    {
        //
    }
}