<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Favourite;
use App\Models\Product;

class FavouriteController extends Controller
{
    public function index()
    {
        $user = auth('api')->user();
        $favourites = $user->Favourite()->pluck('product_id')->toArray();
        $products = Product::whereIn('id', $favourites)->get();
        return Response()->json([
            'data'          => [
                'products'  => $products,
            ],
            'message'       => 'success',
            'code'          => getMsgCode('success'),
        ]);
    }
    public function toggle(Request $request, $id)
    {
        $user = auth('api')->user();
        $data = $request->all();
        if ($user->Favourite()->where('product_id', $id)->first()) {
            $user->Favourite()->where('product_id', $id)->delete();
        } else {
            $user->Favourite()->create(['product_id' => $id]);
        }
        
        
        $favourites = $user->Favourite()->pluck('product_id')->toArray();
        $products = Product::whereIn('id', $favourites)->get();
        return Response()->json([
            'data'          => [
                'products'  => $products,
            ],
            'message'       => 'success',
            'code'          => getMsgCode('success'),
        ]);
    }
}
