<?php
namespace App\Traits\Api;

use Illuminate\Http\Request;
use App\Models\Order;
use App\Models\User;
use App\Models\Driver;
use Carbon\Carbon;
use Auth;
use DB;
use App\Http\Controllers\Api\FCMController;
use App\Models\Admin;
use App\Notifications\AdminNotification;

trait OrderOperations
{
    /**
     * Register a New .
     *
     * @param $request
     * @return \App\
     */
    public function register ($request, $user )
    {
        DB::beginTransaction();
        $data = $request->all();
        $order  = $user->Order()->create($data);
        if ($request->hasFile('images')) {
            foreach ($request->images as $image) {
                $image = uploadImage($image);
                $order->OrderImage()->create(['image' => $image]);
            } 
        }
        // send notification to admin start
        $admin = Admin::first();
        $admin->notify(new AdminNotification('طلب جديد #' . $order->id , route('orders.show', $order->id)));
        // send notification to admin end
        $order->client_code = mt_rand(100000,999999);
        $order->save();
        DB::commit();
        HelpersendSMS($order->User->phone ?? '', "Client Code: ".$order->client_code);
        return $order;
    }


    /**
     * Update Record
     * @param $truck
     * @param $request
     */
    public function UpdateOrderStatus(Order $order,$request)
    {
        $order->update(['status' => $request->get('status')]);
        return $order;
    }
    
    public function SendOrderToDriver($order_id)
    {
        $Order = Order::find($order_id);
        $internal_drivers = Driver::where('type', '<>', 'not_employee')
                                    ->where('is_online', '1')
                                    ->doesnthave('Order', 'or', function($q){
                                        $q->where('status', 'finished');
                                    })
                                    ->get();
        $external_drivers = Driver::where('type', '=', 'not_employee')
                                    ->where('is_online', '1')
                                    ->doesntHave('Order', 'or', function($q){
                                        $q->where('status', 'finished');
                                    })
                                    ->get();
        // send notification to drivers start
        if ($internal_drivers->count() > 0) {
            foreach ($internal_drivers as $driver) {
                // send notification
                
                if( $driver->lang == 'ar')
                {
                    $title = "تم ارسال طلب لك رقم #". $Order->id;
                    $content = "تم ارسال طلب لك رقم #". $Order->id ;

                }else{
                    $title = "You have new Order number #".$Order->id;
                    $content = "You have new Order number #".$Order->id ;
                }
                $type = "new_order";
                
                $title_ar = "تم ارسال طلب لك رقم #".$Order->id;
                $title_en = "You have new Order number #".$Order->id;
                $content_ar = "تم ارسال طلب لك رقم #".$Order->id ;
                $content_en = "You have new Order number #".$Order->id ;
                $activity = "new_order";
                $data2 = [
                    'order' => $Order,
                    'title_ar' => $title_ar,
                    'title_en' => $title_en,
                    'content_ar' => $content_ar,
                    'content_en' => $content_en,
                    'type' => $type,
                ];
                $notifiable = $driver;
                $token = $notifiable->PlayerId()->pluck('player_id')->toArray();
                FCMController::Push($title, $content,$token,$data2);
                // send notification end
            }
        } else {
            foreach ($external_drivers as $driver) {
                // send notification
                
                if( $driver->lang == 'ar')
                {
                    $title = "تم ارسال طلب لك رقم #". $Order->id;
                    $content = "تم ارسال طلب لك رقم #". $Order->id ;

                }else{
                    $title = "You have new Order number #".$Order->id;
                    $content = "You have new Order number #".$Order->id ;
                }
                $type = "new_order";
                
                $title_ar = "تم ارسال طلب لك رقم #".$Order->id;
                $title_en = "You have new Order number #".$Order->id;
                $content_ar = "تم ارسال طلب لك رقم #".$Order->id ;
                $content_en = "You have new Order number #".$Order->id ;
                $activity = "new_order";
                $data2 = [
                    'order' => $Order,
                    'title_ar' => $title_ar,
                    'title_en' => $title_en,
                    'content_ar' => $content_ar,
                    'content_en' => $content_en,
                    'type' => $type,
                ];
                $notifiable = $driver;
                $token = $notifiable->PlayerId()->pluck('player_id')->toArray();
                FCMController::Push($title, $content,$token,$data2);
                // send notification end
            }
        }
        
        // send notification to drivers end
        return $internal_drivers;
    }
    
    
    public function sendSMS($destinations, $message)
    {
        // $username = "Aljeri";		    // اسم المستخدم الخاص بك في الموقع
        // $password = "SmSaljeri_1330"; 		// كلمة المرور الخاصة بك
        // $destinations = $destinations; //الارقام المرسل لها  ,, يتم وضع فاصلة بين الارقام المراد الارسال لها
        // $message = $message;      // محتوى الرسالة
        // $sender = "JTC";         // اسم المرسل الخاص بك المفعل  في الموقع
        // $url = "http://www.jawalbsms.ws/api.php/sendsms?user=$username&pass=$password&to=$destinations&message=$message&sender=$sender";

        // $ch = curl_init($url); // init the curl with jawalb API url
        // curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        // curl_setopt($ch, CURLOPT_HEADER, 0);
        // $data = curl_exec($ch);  //run curl api call, on success curl call, $data will contain the API call response
        // curl_close($ch);
        // // print_r($data);

        $postRequest = array(
            'body' => $message,
            'sender' => 'OTC',
            'recipients' => [
                $destinations
            ]
        );

        $cURLConnection = curl_init('https://api.taqnyat.sa/v1/messages');
        curl_setopt($cURLConnection, CURLOPT_POSTFIELDS, json_encode($postRequest));
        curl_setopt($cURLConnection, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($cURLConnection, CURLOPT_HTTPHEADER, array(
            'Authorization: Bearer 2097057f9ffbb1836fa24795c10e7915',
            'Content-Type: application/json'
        ));

        $apiResponse = curl_exec($cURLConnection);
        curl_close($cURLConnection);

        // $apiResponse - available data from the API request
        $jsonArrayResponse = json_decode($apiResponse);
        return $jsonArrayResponse;
    }

}