<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Mission extends Model
{
    protected $table='missions';
    protected $fillable = [
        'image', 'name_ar', 'name_en', 'active',
    ];
    protected $appends = [
        'name',
    ];

    public function getNameAttribute()
    {
        if (Request()->header('lang') == 'en') {
            return $this->name_en;
        }else{
            return $this->name_ar;
        }
    }
    public function Product()
    {
        return $this->Hasmany(Product::class, 'mission_id');
    }


    public function getImageAttribute($img)
    {
        if($img)
        {
            return url('/').'/cdn/'.$img;
        }
        return $img;

    }

}
