<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Category extends Model
{
    protected $table='categories';
    protected $fillable = [
        'image', 'name_ar', 'name_en', 'product_image'
    ];
    protected $appends = [
        'name',
    ];

    public function getNameAttribute()
    {
        if (Request()->header('lang') == 'en') {
            return $this->name_en;
        }else{
            return $this->name_ar;
        }
    }
    public function Product()
    {
        return $this->Hasmany(Product::class, 'category_id');
    }

    public function getImageAttribute($img)
    {
        if($img)
        {
            return url('/').'/cdn/'.$img;
        }
        return $img;

    }
    public function getProductImageAttribute($img)
    {
        if($img)
        {
            return url('/').'/cdn/'.$img;
        }
        return $img;

    }
}
