<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class VIPCartController extends Controller
{
    public function addToCart(Request $request)
    {
        $user = auth('api')->user();
        $data = $request->all();
        $user->VipCart()->create($data);
        $cart = $user->VipCart()->get();
        return Response()->json([
            'data'          => [
                'cart'  => $cart,
            ],
            'message'       => 'success',
            'code'          => getMsgCode('success'),
        ]);
    }
    public function viewCart(Request $request)
    {
        $user = auth('api')->user();
        $cart = $user->VipCart()->get();
        return Response()->json([
            'data'          => [
                'cart'  => $cart,
            ],
            'message'       => 'success',
            'code'          => getMsgCode('success'),
        ]);
    }
    public function removeFromCart(Request $request)
    {
        $user = auth('api')->user();
        $user->VipCart()->where('id', $request->get('cart_item_id'))->delete();
        $cart = $user->VipCart()->get();
        return Response()->json([
            'data'          => [
                'cart'  => $cart,
            ],
            'message'       => 'success',
            'code'          => getMsgCode('success'),
        ]);
    }
}
