<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Transaction;
use App\Models\Order;
use App\Models\User;
use Carbon\Carbon;
use Auth;

class HomeController extends Controller
{
    public function index()
    {
        $users_chart = User::whereDate('created_at', '>=', Carbon::now()->subMonths(6) )
                            ->whereDate('created_at', '<=', Carbon::now())
                            ->select( \DB::raw('COUNT(*) as a, DATE_FORMAT(created_at, "%Y-%m") as y'))
                            // ->groupBy('user_id')
                            ->groupBy('y')
                            ->get();
        // $orders_chart = Transaction::whereDate('created_at', '>=', Carbon::now()->subMonths(6) )
        //                     ->whereDate('created_at', '<=', Carbon::now())
        //                     ->select( \DB::raw('SUM(`amount`) as a, DATE_FORMAT(created_at, "%Y-%m") as y'))
        //                     // ->groupBy('user_id')
        //                     ->groupBy('y')
        //                     ->get()->each(function($p){
        //                         $x = Carbon::parse($p->y)->subYears(1)->format('Y-m');
        //                         $x = Transaction::whereDate('created_at', $x)->sum('amount');
        //                         $p->b = $x;
        //                     });
        $orders_chart = Order::whereDate('created_at', '>=', Carbon::now()->subMonths(6) )
                            ->whereDate('created_at', '<=', Carbon::now())
                            ->select( \DB::raw('SUM(`total_price`) as a, DATE_FORMAT(created_at, "%Y-%m") as y'))
                            // ->groupBy('user_id')
                            ->groupBy('y')
                            ->get()->each(function($p){
                                $x = Carbon::parse($p->y)->subYears(1)->format('Y-m');
                                $x = Order::whereDate('created_at', $x)->sum('total_price');
                                $p->b = $x;
                            });

    	$now = Carbon::now();
        $orders = Order::latest();
    	$search = array();
    	if (Request()->has('days') && Request()->get('days') != '') {
    		$days = Request()->get('days');
    		$search['days'] = $days;
            $orders = $orders->whereDate('created_at' , '>=', Carbon::now()->subDays($days) );
    	}
        if (Request()->has('status') && Request()->get('status') != '') {
            $status = Request()->get('status');
            $search['status'] = $status;
            $orders = $orders->where('status'     , $status);
        }
        if (Request()->has('trip_type') && Request()->get('trip_type') != '') {
            $trip_type = Request()->get('trip_type');
            $search['trip_type'] = $trip_type;
            $orders = $orders->where('trip_type'     , $trip_type);
        }
        $orders = $orders->paginate(10);
    	return view('admin.main', compact('search', 'users_chart', 'orders_chart', 'orders'));
    }
}
